package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.vo.zssj.CusOrderZssjQualityReqVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author zcc
 * @date 2022/8/17 16:56
 **/
@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/zssj/order")
public interface CusOrderZssjServiceFeign {

    /**
     * 获取订单质保单图片url
     * @param zssjQualityReqVo
     * @return
     */
    @PostMapping(value = "/getOrderQualityImgUrl")
    ResponseData<String> getOrderQualityImgUrl(@RequestBody @Valid CusOrderZssjQualityReqVo zssjQualityReqVo);
}
