package com.bizvane.customized.facade.models.vo.ur;

import lombok.Data;

/**
 * @author yuantq
 * @date 2022/1/10
 */
@Data
public class TenderModel {

    /**
     * 交易时间，格式为"yyyyMMddHHmmss"
     */
    private String time;

    /**
     * 商户系统中的交易单号，每种付款方式下唯一
     */
    private String transaction_sn;

    /**
     * 渠道订单号，如果没有则填写空值
     */
    private String channel_sn;

    /**
     * 支付方式编号
     */
    private String tender_code;

    /**
     * 支付方式描述，如微信/支付宝/礼品卡等
     */
    private String tender_desc;

    /**
     * 子支付方式编号
     */
    private String sub_tender_code;

    /**
     * 子支付方式描述
     */
    private String sub_tender_desc;

    /**
     * 商户应收金额，单位是分，退货时金额传负数
     */
    private String amount;

    /**
     * 商户实收金额，单位是分，退货时金额传负数
     */
    private String collected_amount;

    /**
     * 顾客实际付款金额，单位是分，退货时金额传负数
     */
    private String paid_amount;

}
