package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.vo.mj.CurMjRequestVo;
import com.bizvane.customized.facade.models.vo.mj.WashProtectVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author zcc
 * @date 2021/9/27 15:58
 **/
@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/mengJieRpc")
public interface CusMengJieServiceFeign {

    /**
     * 获取梦洁洗护金信息
     * @param mobile
     * @return
     */
    @RequestMapping(value = "/getWashProtectVoByPhone",method = RequestMethod.GET)
    public ResponseData<WashProtectVo> getWashProtectVoByPhone(@RequestParam(value = "mobile",required = true)String mobile);


    /**
     * 查询会员即将过期积分
     * @param requestVo
     * @return
     */
    @ApiOperation(value = "查询会员即将过期积分",notes = "查询会员即将过期积分",tags = {"mj"},httpMethod = "POST")
    @RequestMapping(value = "queryExpireIntegral", method = RequestMethod.POST)
    ResponseData<Long> queryExpireIntegral(@RequestBody CurMjRequestVo requestVo);
}
