package com.bizvane.customized.facade.models.vo.ur;

import lombok.Data;

/**
 * 商品明细
 * @author yuantq
 * @date 2022/1/10
 */
@Data
public class ItemModel {

    /**
     * 商品编码
     */
    private String item_code;

    /**
     * 商品描述
     */
    private String item_desc;

    /**
     * 	商品分类
     */
    private String category;

    /**
     * 商品规格
     */
    private String specification;

    /**
     * 商品计量单位
     */
    private String unit;

    /**
     * 商品数量，退货时商品数量传负数
     */
    private String item_qty;

    /**
     * 商品单价，单位是分
     */
    private String item_price;

    /**
     * 成交价格，单位是分，退货时金额传负数
     */
    private String sales_price;

    /**
     * 交易类型，0 代表销售，1 代表退货
     */
    private String type;

    /**
     * 当 type 为 1 时，填写订单交易原门店编号
     */
    private String return_store_sn;

    /**
     * 当 type 为 1 时，填写订单交易原款台编号
     */
    private String return_workstation_sn;

    /**
     * 当 type 为 1 时，填写订单原交易单号
     */
    private String return_check_sn;

}
