package com.bizvane.customized.facade.interfaces;


import com.bizvane.customized.facade.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/ur/storageCardRpc")
@Api(tags = {"储值卡RPC接口"}, description = "与线下交互接口")
public interface StorageCardServiceFeign {


    /**
     * 根据会员卡号查询储值卡信息
     *
     * @param storageQueryCardRequestVO
     * @return
     */
    @PostMapping(value = "/getStorageCardByVipCard")
    ResponseData<StorageCardQueryVipCardResponseVO> getStorageCardByVipCard(@RequestBody @Valid StorageCardQueryVipCardRequestVO storageQueryCardRequestVO);

    /**
     * 储值卡消费
     *
     * @param storageCardConsumeRequestVO
     * @return
     */
    @PostMapping(value = "/storageConsume")
    ResponseData<String> storageConsume(@RequestBody @Valid StorageCardConsumeRequestVO storageCardConsumeRequestVO);


    /**
     * 根据储值卡号查询信息
     *
     * @param storageCardQueryStorageCardRequestVO
     * @return
     */
    @PostMapping(value = "/getStorageCardByStorageCard")
    ResponseData<StorageCardQueryStorageCardResponseVO> getStorageCardByStorageCard(@RequestBody @Valid StorageCardQueryStorageCardRequestVO storageCardQueryStorageCardRequestVO);


	@ApiOperation(value = "储值卡转增", notes = "微信公众号小程序调用此接口转赠储值卡")
	@PostMapping("/sendStorageCard")
	ResponseData sendStorageCard(@RequestBody CusUrStorageCardSendVO vo);

	@ApiOperation(value = "储值卡受赠", notes = "微信公众号小程序调用此接口获取受赠的储值卡")
	@PostMapping("/receivedStorageCard")
	ResponseData receivedSendStorageCard(@RequestBody CusUrStorageCardReceivedVO vo);
}
