/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.facade.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OkHttpUtils {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtils.class);

    public String getRequest(String url) throws IOException {
        log.info("\u8bf7\u6c42\u4fe1\u606furl---->{}", (Object)url);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request = new Request.Builder().url(url).method("GET", null).addHeader("Cookie", "PHPSESSID=d2a5a9a779916e0053ff3520c6763759").build();
        Response response = client.newCall(request).execute();
        String result = null;
        if (response != null) {
            if (response.body() != null) {
                result = new String(response.body().bytes());
                response.body().close();
            }
            response.close();
        }
        log.info("result---->{}", result);
        return result;
    }

    public JSONObject httpGet(String url, Map<String, String> params, boolean flag) {
        OkHttpClient okHttpClient = new OkHttpClient();
        StringBuilder paramsStr = new StringBuilder();
        if (!CollectionUtils.isEmpty(params)) {
            params.keySet().forEach(res -> {
                if (StringUtils.isNotBlank((CharSequence)paramsStr) || flag) {
                    paramsStr.append("&");
                } else {
                    paramsStr.append("?");
                }
                try {
                    paramsStr.append(String.format("%s=%s", res, URLEncoder.encode((String)params.get(res), "UTF-8")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    log.info("httpGet method(),unsupportedEncodingException:{}", (Object)ExceptionUtils.getStackTrace((Throwable)unsupportedEncodingException));
                }
            });
        }
        String requestUrl = url + paramsStr;
        log.info("httpGet method(),requestUrl:{}", (Object)requestUrl);
        Request request = new Request.Builder().url(requestUrl).get().addHeader("accept", "application/json; charset=utf-8").build();
        try {
            Response response = okHttpClient.newCall(request).execute();
            response.close();
            JSONObject jsonObjectResult = JSONObject.parseObject((String)response.body().toString());
            log.info("httpGet jsonObjectResult:{}", (Object)jsonObjectResult.toJSONString());
            return jsonObjectResult;
        }
        catch (Exception exception) {
            log.info("httpGet method(),exception:{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            return null;
        }
    }
}

