package com.bizvane.customized.facade.models.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CusUrRefundAuditRespVo {

    @ApiModelProperty(value = "储蓄卡卡号")
    private String cardNo;

    @ApiModelProperty(value = "会员姓名")
    private String memberName;

    @ApiModelProperty(value = "会员手机号")
    private String memberPhone;

    @ApiModelProperty(value = "申请人姓名(id)")
    private String applyRefundName;

    @ApiModelProperty(value = "退款金额")
    private BigDecimal  rechargeBalanceAmount;

    @ApiModelProperty(value = "申请退款时间")
    private Date applyDate;

    @ApiModelProperty(value = "退款记录编号")
    private Long refundRecordId;

    @ApiModelProperty(value = "当前会员余额")
    private BigDecimal memberBalance;


}
