/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.crypto.utils;

import com.bizvane.crypto.nacos.NacosConfig;
import com.bizvane.crypto.utils.SM3Utils;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4Utils {
    public static String decryptSM4(String encryptedData, String sm4Key) {
        try {
            Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", "BC");
            SecretKeySpec keySpec = new SecretKeySpec(SM4Utils.hexStringToByteArray(sm4Key), "SM4");
            cipher.init(2, keySpec);
            byte[] data = SM4Utils.hexStringToByteArray(encryptedData);
            byte[] decryptedData = cipher.doFinal(data);
            return new String(decryptedData);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u57fa\u4e8eSM4\u7b97\u6cd5\u89e3\u5bc6\u5f02\u5e38\uff0c\u5bc6\u6587\uff1a%s\uff0c\u5bc6\u94a5\uff1a%s", encryptedData, sm4Key), e);
        }
    }

    public static String encryptSM4(String data, String sm4Key) {
        try {
            Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", "BC");
            SecretKeySpec keySpec = new SecretKeySpec(SM4Utils.hexStringToByteArray(sm4Key), "SM4");
            cipher.init(1, keySpec);
            byte[] encryptedData = cipher.doFinal(data.getBytes());
            return SM4Utils.byteArrayToHex(encryptedData);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u57fa\u4e8eSM4\u7b97\u6cd5\u89e3\u5bc6\u5f02\u5e38\uff0c\u660e\u6587\uff1a%s\uff0c\u5bc6\u94a5\uff1a%s", data, sm4Key), e);
        }
    }

    public static String encrypt(String data, String bizCode) {
        String sm4Key = NacosConfig.getSecretKey(bizCode);
        return SM4Utils.encryptSM4(data, sm4Key);
    }

    public static String decrypt(String data, String bizCode) {
        String sm4Key = NacosConfig.getSecretKey(bizCode);
        return SM4Utils.decryptSM4(data, sm4Key);
    }

    public static String byteArrayToHex(byte[] bytes) {
        return SM3Utils.byteArrayToHex(bytes);
    }

    private static byte[] hexStringToByteArray(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

