package com.bizvane.crypto.utils;

import com.bizvane.crypto.nacos.NacosConfig;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.security.Security;

public class SM4Utils {
    // 静态块初始化 BouncyCastle 提供者
    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    /**
     * SM4 解密
     * @param encryptedData 密文
     * @param sm4Key 密钥(16字节)
     */
    public static String decryptSM4(String encryptedData, String sm4Key) {
        try {
            Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", "BC");
            SecretKeySpec keySpec = new SecretKeySpec(hexStringToByteArray(sm4Key), "SM4");
            cipher.init(Cipher.DECRYPT_MODE, keySpec);
            byte[] data = hexStringToByteArray(encryptedData);
            byte[] decryptedData = cipher.doFinal(data);
            return new String(decryptedData);
        }catch (Exception e){
            throw new RuntimeException(String.format("基于SM4算法解密异常，密文：%s，密钥：%s",encryptedData,sm4Key),e);
        }
    }

    /**
     * SM4 加密
     * @param data 明文
     * @param sm4Key 密钥(16字节)
     */
    public static String encryptSM4(String data, String sm4Key){
        try {
            Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", "BC");
            SecretKeySpec keySpec = new SecretKeySpec(hexStringToByteArray(sm4Key), "SM4");
            cipher.init(Cipher.ENCRYPT_MODE, keySpec);
            byte[] encryptedData = cipher.doFinal(data.getBytes());
            return byteArrayToHex(encryptedData);
        }catch (Exception e){
            throw new RuntimeException(String.format("基于SM4算法解密异常，明文：%s，密钥：%s",data,sm4Key),e);
        }
    }

    /**
     * 根据业务标识，对数据进行加密
     * @param data 明文
     * @param bizCode 业务标识
     * @return 密文
     */
    public static String encrypt(String data,String bizCode){
        String sm4Key = NacosConfig.getSecretKey(bizCode);
        return encryptSM4(data,sm4Key);
    }

    /**
     * 根据业务标识，对数据进行解密
     * @param data 密文
     * @param bizCode 业务标识
     * @return 明文
     */
    public static String decrypt(String data,String bizCode) {
        String sm4Key = NacosConfig.getSecretKey(bizCode);
        return decryptSM4(data,sm4Key);
    }

    public static String byteArrayToHex(byte[] bytes) {
        return SM3Utils.byteArrayToHex(bytes);
    }


    // 将16进制字符串转换为字节数组
    private static byte[] hexStringToByteArray(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte) ((Character.digit(hex.charAt(i), 16) << 4)
                + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }
}
