/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.crypto.advice;

import com.bizvane.crypto.annotation.ResponseEncryptField;
import com.bizvane.crypto.utils.SM3Utils;
import com.bizvane.crypto.utils.SM4Utils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseEncryptAdvice
implements ResponseBodyAdvice<Object> {
    @Value(value="${spring.crypto.header-key:deviceId}")
    private String cryptoKey;
    @Autowired
    private HttpServletRequest request;
    private static final int MAX_RECURSION_DEPTH = 10;
    private static final Cache<Class<?>, Field[]> FIELD_CACHE = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).weakKeys().build();

    @PostConstruct
    public void init() {
        System.out.println("ResponseEncryptAdvice inited.");
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest serverHttpRequest, ServerHttpResponse response) {
        if (body == null) {
            return null;
        }
        String deviceId = this.request.getHeader(this.cryptoKey);
        if (deviceId == null || deviceId.trim().isEmpty()) {
            return body;
        }
        String keyHex = SM3Utils.generateKeyHex(deviceId);
        this.processFields(body, keyHex);
        return body;
    }

    private void processFields(Object object, String keyHex) {
        this.processFieldsInternal(object, keyHex, new HashSet<Object>(), 0);
    }

    private void processFieldsInternal(Object object, String keyHex, Set<Object> processedObjects, int recursionDepth) {
        if (object == null || processedObjects.contains(object)) {
            return;
        }
        if (recursionDepth > 10) {
            return;
        }
        processedObjects.add(object);
        Class<?> clazz = object.getClass();
        if (this.isSimpleValueType(clazz)) {
            return;
        }
        try {
            Field[] fields;
            if (object instanceof Collection) {
                for (Object item : (Collection)object) {
                    this.processFieldsInternal(item, keyHex, processedObjects, recursionDepth + 1);
                }
                return;
            }
            if (clazz.isArray()) {
                for (int i = 0; i < Array.getLength(object); ++i) {
                    Object item = Array.get(object, i);
                    this.processFieldsInternal(item, keyHex, processedObjects, recursionDepth + 1);
                }
                return;
            }
            if (object instanceof Map) {
                for (Object value : ((Map)object).values()) {
                    this.processFieldsInternal(value, keyHex, processedObjects, recursionDepth + 1);
                }
                return;
            }
            for (Field field : fields = this.getDeclaredFields(clazz)) {
                field.setAccessible(true);
                Object value = field.get(object);
                ResponseEncryptField annotation = field.getAnnotation(ResponseEncryptField.class);
                if (annotation != null && value instanceof String && !StringUtils.isEmpty((Object)value)) {
                    String encryptedText = SM4Utils.encryptSM4((String)value, keyHex);
                    field.set(object, encryptedText);
                }
                this.processFieldsInternal(value, keyHex, processedObjects, recursionDepth + 1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process the field", e);
        }
    }

    private boolean isSimpleValueType(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || Date.class.isAssignableFrom(clazz) || LocalDateTime.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz);
    }

    private Field[] getDeclaredFields(Class<?> clazz) {
        return (Field[])FIELD_CACHE.get(clazz, Class::getDeclaredFields);
    }
}

