
package com.bizvane.couponfacade.models.vo;


import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @author baofeng@zhidemai.com
 * @createTime 2024-10-07 19:51:22
 * @description: 361定制优惠券核销方式查询结果对象
 */
@Data
public class CouponUseType361ResultVO {

    private String brandCode;
    private String couponCode;

    // 券的优惠方式：1-现金券、2-折扣券
    private Integer preferentialType;


    // 费用金额
    @ApiModelProperty(value = "费用金额", name = "costAmount")
    private BigDecimal costAmount;

    // 应收金额
    @ApiModelProperty(value = "应收金额", name = "receivableAmount")
    private BigDecimal receivableAmount;

    // 折让金额
    @ApiModelProperty(value = "折让金额", name = "rebateAmount")
    private BigDecimal rebateAmount;

    // 备用金额1
    @ApiModelProperty(value = "备用金额1", name = "reserveAmount1")
    private BigDecimal reserveAmount1;

    // 备用金额2
    @ApiModelProperty(value = "备用金额2", name = "reserveAmount2")
    private BigDecimal reserveAmount2;

    // 客户
    @ApiModelProperty(value = "客户", name = "customer")
    private String customer;

    // OA流程编号
    @ApiModelProperty(value = "OA流程编号", name = "oaFlowCode")
    private String oaFlowCode;

    // 券投放平台
    @ApiModelProperty(value = "券投放平台", name = "couponDeliveryPlatform")
    private String couponDeliveryPlatform;

}
