package com.bizvane.couponfacade.interfaces;

import com.bizvane.centerstageservice.models.vo.UrActivityCheckVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author bizvane
 */
@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/couponCheckRpc")
@Api(value = "手工发券",tags = {"API"})
public interface CouponCheckServiceFeign {

  @ApiOperation(value = "手动发券任务审核接口", notes = "手动发券任务审核接口", tags = {"手动发券接口Rpc"},httpMethod = "POST")
  @PostMapping(value="/changeCheckStatusRpc")
  ResponseData<String> changeCheckStatus(@RequestBody UrActivityCheckVo urActivityCheckVo);
}
