package com.bizvane.couponfacade.models.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
/**
 * @author bizvane
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class CouponEntityResponseBO implements Serializable {

	/**
	 * 只读. 券号. coupon_code
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "券号", name = "couponCode", required = false, example = "")
	private String couponCode;

	/**
	 * 只读. 券定义id. coupon_definition_id
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "券定义id", name = "couponDefinitionId", required = false, example = "")
	private String couponDefinitionId;

	/**
	 * 只读. 会员code. member_code
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "会员code", name = "memberCode", required = false, example = "")
	private String memberCode;

	/**
	 * 只读. 券名称. coupon_name
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "券名称", name = "couponName", required = false, example = "")
	private String couponName;

	/**
	 * 只读. 面额. money
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "面额", name = "money", required = false, example = "")
	private BigDecimal money;

	/**
	 * 只读. 折扣. discount
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "折扣", name = "discount", required = false, example = "")
	private BigDecimal discount;

	/**
	 * 只读. 券说明. info
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "券说明", name = "info", required = false, example = "")
	private String info;

	/**
	 * 只读. 有效期开始时间. valid_date_start
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "有效期开始时间", name = "validDateStart", required = false, example = "")
	private Date validDateStart;

	/**
	 * 只读. 有效期结束时间. valid_date_end
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "有效期结束时间", name = "validDateEnd", required = false, example = "")
	private Date validDateEnd;

	/**
	 * 只读. 是否锁定(0-未锁定 1-锁定). is_lock
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "是否锁定(0-未锁定 1-锁定)", name = "isLock", required = false, example = "")
	private Boolean isLock;

	/**
	 * 只读. 使用类型：1-线上，2-线下. use_type
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "使用类型：1-线上，2-线下", name = "useType", required = false, example = "")
	private Byte useType;

	/**
	 * 只读. 核销门店. use_store_id
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "核销门店", name = "useStoreCode", required = false, example = "")
	private String useStoreCode;

	/**
	 * 只读. 订单号. use_business_code
	 * @mbg.generated  2019-08-06 17:06:56
	 */

	@io.swagger.annotations.ApiModelProperty(value = "订单号", name = "useBusinessOrder", required = false, example = "")
	private String useBusinessOrder;

	/**
	 * 只读. 券使用订单金额(券收益)示例88.88. use_business_amount
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "券使用订单金额(券收益)", name = "useBusinessAmount", required = false, example = "88.88")
	private BigDecimal useBusinessAmount;

	/**
	 * 只读. 使用时间. use_time
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "使用时间", name = "useTime", required = false, example = "")
	private Date useTime;

	/**
	 * 只读. 是否使用(1-已使用，0-未使用). is_use
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "是否使用(1-已使用，0-未使用)", name = "isUse", required = false, example = "")
	private Boolean isUse;

	/**
	 * 只读. //5-线上绑定，10-同步中，11-同步失败，//12-同步成功，20-未使用，25-已过期，30-已核销,35-已作废. coupon_status
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "//5-线上绑定，10-同步中，11-同步失败，//12-同步成功，20-未使用，25-已过期，30-已核销,35-已作废", name = "couponStatus", required = false, example = "")
	private Byte couponStatus;

	/**
	 * 只读. 优惠类型（1现金，2折扣，3礼品）. preferential_type
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "优惠类型（1现金，2折扣，3礼品）", name = "preferentialType", required = false, example = "")
	private Byte preferentialType;

	/**
	 * 只读. 转赠状态 (0-未转赠，1-转赠中). give
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	@io.swagger.annotations.ApiModelProperty(value = "转赠状态 (0-未转赠，1-转赠中)", name = "give", required = false, example = "")
	private Boolean give;

	/**
	 * 只读. 
	 * @mbg.generated  2019-08-06 17:06:56
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 线下卷类型号
	 * */
	private String erpCouponDefinitionCode;

	/**
	 * 渠道限制（1仅线下，2全渠道，3仅线上，4员工券，5天猫券）
	 * */
	private Byte useChannel;

	@ApiModelProperty(value = "创建时间", name = "createDate")
	private Date createDate;

	@ApiModelProperty(value = "修改时间", name = "modifiedDate")
	private Date modifiedDate;

	@ApiModelProperty(value = "券是否隐藏 1是0否已隐藏仅代表不在会员中心显示，券状态未做修改", name = "isHide")
	private Integer isHide;

}