package com.bizvane.couponfacade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author zcc
 * @date 2022/3/24 15:10
 **/

@Data
public class ZdsSendCouponVO implements Serializable {

    private static final long serialVersionUID = 7886446606797080185L;

    @ApiModelProperty(value = "企业id",name = "企业id", required = true,example = "")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id",name = "品牌id", required = true,example = "")
    private Long sysBrandId;

    @ApiModelProperty(value = "券定义线下id", name = "erpCouponDefinitionCode", required = false,example = "")
    private String erpCouponDefinitionCode;

    @ApiModelProperty(value = "发送类型", name = "sendType", required = false,example = "")
    private String sendType;

    @ApiModelProperty(value = "发券业务名称", name = "businessName", required = false,example = "")
    private String businessName;

    @ApiModelProperty(value = "发券业务单号1", name = "sendBusinessId1", required = false,example = "")
    private String sendBusinessId1;

    @ApiModelProperty(value = "发券业务单号2", name = "sendBusinessId2", required = false,example = "")
    private String sendBusinessId2;

    @ApiModelProperty(value = "批量发券单号1", name = "couponBatchSendRecordId1", required = false,example = "")
    private String couponBatchSendRecordId1;

    @ApiModelProperty(value = "批量发券单号2", name = "couponBatchSendRecordId2", required = false,example = "")
    private String couponBatchSendRecordId2;

    @ApiModelProperty(value = "发送员工code", name = "sendStaffCode", required = false,example = "")
    private String sendStaffCode;

    @ApiModelProperty(value = "发送时间", name = "sendDate", required = false,example = "")
    private Date sendDate;

    @ApiModelProperty(value = "创建人id", name = "createUserId", required = false,example = "")
    private Long createUserId;

    @ApiModelProperty(value = "创建人", name = "createUserName", required = false,example = "")
    private String createUserName;

    @ApiModelProperty(value = "创建时间", name = "createDate", required = false,example = "")
    private Date createDate;

    @ApiModelProperty(value = "会员集合", name = "sendCouponMemberVoList", required = false,example = "")
    private List<SendCouponMemberVo> sendCouponMemberVoList;


}
