package com.bizvane.couponfacade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zcc
 * @date 2022/3/24 14:36
 **/

@Data
public class ZdsSendCouponQuotaBatchRequestVO implements Serializable {

    private static final long serialVersionUID = 4358989718022184262L;

    @ApiModelProperty(value = "券定义id", name = "couponDefinitionId", required = false,example = "")
    private Long couponDefinitionId;

    @ApiModelProperty(value = "券定义线下id", name = "erpCouponDefinitionCode", required = false,example = "")
    private String erpCouponDefinitionCode;

    @ApiModelProperty(value = "任务名称" , name = "businessName" , required = false , example = "")
    private String businessName;

    @ApiModelProperty(value = "业务id" , name = "businessId" , required = false , example = "")
    private Long businessId;

    @ApiModelProperty(value = "业务类型" , name = "businessType" , required = false , example = "")
    private String businessType;

    @io.swagger.annotations.ApiModelProperty(value = "创建人id",name = "createUserId", required = false,example = "")
    private Long createUserId;

    @io.swagger.annotations.ApiModelProperty(value = "创建人",name = "createUserName", required = false,example = "")
    private String createUserName;

    @io.swagger.annotations.ApiModelProperty(value = "员工code",name = "staffCode", required = true,example = "")
    private String staffCode;

    @io.swagger.annotations.ApiModelProperty(value = "员工名称",name = "staffName", required = true,example = "")
    private String staffName;

    @io.swagger.annotations.ApiModelProperty(value = "企业id",name = "企业id", required = true,example = "")
    private Long sysCompanyId;

    @io.swagger.annotations.ApiModelProperty(value = "品牌id",name = "品牌id", required = true,example = "")
    private Long sysBrandId;

    @io.swagger.annotations.ApiModelProperty(value = "发送会员数量",name = "发送会员数量", required = true,example = "")
    private Integer memberNum;

    @io.swagger.annotations.ApiModelProperty(value = "券配额表主键",name = "券配额表主键", required = false,example = "")
    private Long couponQuotaId;

    @io.swagger.annotations.ApiModelProperty(value = "", name = "couponQuotaDetailId", required = false, example = "")
    private Long couponQuotaDetailId;

    @io.swagger.annotations.ApiModelProperty(value = "会员code,逗号拼接",name = "会员code,逗号拼接", required = true,example = "")
    private List<SendCouponMemberVo>  sendCouponMemberVoList;
}
