package com.bizvane.couponfacade.interfaces;

import com.bizvane.couponfacade.models.vo.ZdsSendCouponQuotaBatchRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @version 1.0
 * @author: WQK
 * @data: 2022-03-23 13:48
 */

@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/zdsSendCoupon")
@Api(value = "发券",tags = {"API"})
public interface ZdsSendCouponServiceFeign {


    /**
     * 批量发券
     * @return
     */
    @ApiOperation(value = "企业微信批量发券接口", notes = "企业微信批量发券接口", tags = {"券消息配置"},httpMethod = "POST")
    @RequestMapping(value="/couponQuotaBatchRpc", method = RequestMethod.POST)
    ResponseData<String> couponQuotaBatchRpc(@RequestBody ZdsSendCouponQuotaBatchRequestVO vo);


}
