package com.bizvane.couponfacade.interfaces;

import com.bizvane.couponfacade.models.vo.ZdsCouponDefinitionRequestVO;
import com.bizvane.couponfacade.models.vo.ZdsCouponDefinitionVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @version 1.0
 * @author: WQK
 * @data: 2022-03-23 11:49
 */
@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/zdsCouponDefinitionRpc")
@Api(value = "券定义管理",tags = {"券定义管理"})
public interface ZdsCouponDefinitionServiceFeign {

    /**
     * 查找单个券定义接口
     * @param sysBrandId
     * @param erpCouponDefinitionCode
     * @return
     */
    @ApiOperation(value = "查找单个券定义接口",notes = "查找单个券定义接口",tags = {"券定义接口"},httpMethod = "POST")
    @RequestMapping(value="findByErpCouponDefinitionCode", method = RequestMethod.POST)
    ResponseData<ZdsCouponDefinitionVo> zdsFindByIdRpc(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("erpCouponDefinitionCode") String erpCouponDefinitionCode);

    /**
     * 查找券定义列表接口
     *
     * @param zdsCouponDefinitionReqVO
     * @return
     */
    @ApiOperation(value = "查找券定义列表接口", notes = "查找券定义列表接口", tags = {"券定义分页接口"}, httpMethod = "POST")
    @PostMapping(value = "/findCouponDefinitionPage")
    ResponseData<PageInfo<ZdsCouponDefinitionVo>> findCouponDefinitionPage(@RequestBody ZdsCouponDefinitionRequestVO zdsCouponDefinitionReqVO);
}
