package com.bizvane.couponfacade.interfaces;
/*
 * Created by JiangWenjian on 2019-12-02.
 */

import com.bizvane.couponfacade.models.bo.CouponEntityAvailResponseBO;
import com.bizvane.couponfacade.models.bo.CouponOrderAvailableBO;
import com.bizvane.couponfacade.models.po.CouponOrderEntityPO;
import com.bizvane.couponfacade.models.vo.CouponOrderEntityVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author jiangwenjian
 * @version 0.0.1
 * @since 0.0.1 2019-12-02
 */
@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/couponVerify")
@Api("订单券核销前验证")
public interface CouponVerifyServiceFeign {

    /**
     * 根据所传传条件判断券是否可用
     * @param couponOrderEntity
     * @return
     */
    @ApiOperation(value = "根据所传传条件判断券是否可用",notes = "根据所传传条件判断券是否可用",tags = {"券定义接口"},httpMethod = "POST")
    @RequestMapping(value="verifyCouponRules", method = RequestMethod.POST)
    ResponseData<CouponOrderEntityVO> verifyCouponRules(@RequestBody CouponOrderEntityPO couponOrderEntity);

    /**
     * 根据所传传条件返回券列表
     * @param bo
     * @return
     */
    @ApiOperation(value = "根据所传传条件返回券列表",notes = "根据所传传条件返回券列表",tags = {"券定义接口"},httpMethod = "POST")
    @RequestMapping(value="mbrAvailableCouponList", method = RequestMethod.POST)
    ResponseData<PageInfo<CouponEntityAvailResponseBO>> mbrAvailableCouponList(@RequestBody CouponOrderAvailableBO bo);
}
