package com.bizvane.core.facade.interfaces.fallBack;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.core.facade.constants.ActionLogConstant;
import com.bizvane.core.facade.interfaces.feign.SysActionLogServiceFeign;
import com.bizvane.core.facade.models.vo.SysActionLogVO;
import com.bizvane.utils.responseinfo.ResponseData;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.producer.SendResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class ActionLogFeignFallBack implements FallbackFactory<SysActionLogServiceFeign> {
    @Autowired(required = false)
    private RocketMQTemplate rocketMQTemplate;

    @Override
    public SysActionLogServiceFeign create(Throwable throwable) {
        return new SysActionLogServiceFeign() {
            @Override
            public ResponseData insert(SysActionLogVO sysActionLogVO) {
                log.info("SysActionLogServiceFeign的insert方法调用失败,异步发送到mq中");
                String topic = ActionLogConstant.ACTIONLOGTOPIC;
                String applicationName = sysActionLogVO.getApplicationName();
                Destination destination = new Destination(topic,applicationName,null);
                if(rocketMQTemplate != null){
                    SendResult send = rocketMQTemplate.send(destination, sysActionLogVO);
                    log.info("SysActionLogServiceFeign的insert方法调用失败,异步发送到mq中,发送结果:{}", JSONObject.toJSONString(send));
                }
                return new ResponseData(500,"添加失败");
            }
        };
    }
}
