/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.core.facade.interfaces;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.core.facade.interfaces.feign.ActionLogFeign;
import com.bizvane.core.facade.models.vo.SysActionLogVO;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import java.net.URLDecoder;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import jodd.util.StringUtil;
import org.jboss.logging.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class CollectActionLog {
    @Autowired
    private HttpServletRequest request;
    @Value(value="${spring.application.name}")
    private String appName;
    @Autowired(required=false)
    private ActionLogFeign actionLogFeign;
    private static final String TRACE_ID = "traceId";

    @Async
    public void collect(String content, Byte operationType, String mark) {
        SysActionLogVO sysActionLogVO = new SysActionLogVO();
        sysActionLogVO.setApplicationName(this.appName);
        sysActionLogVO.setCreateDate(new Date());
        sysActionLogVO.setLogContent(content);
        sysActionLogVO.setOperationType(operationType);
        sysActionLogVO.setMark(mark);
        Object o = MDC.get((String)TRACE_ID);
        if (o != null && o instanceof String) {
            sysActionLogVO.setTraceid((String)o);
        }
        sysActionLogVO.setIpAddress(this.getIpAddress(this.request));
        sysActionLogVO.setControllerUrl(this.request.getRequestURL().toString());
        sysActionLogVO.setRequestMethod(this.request.getMethod());
        sysActionLogVO.setContentType(this.request.getHeader("Content-Type"));
        String sysLogJson = this.request.getHeader("bizvaneLogs");
        JSONObject jsonObject = this.decrypt(sysLogJson);
        if (jsonObject != null) {
            SysAccountPO stageUser;
            String sourece = (String)jsonObject.get((Object)"sourece");
            sysActionLogVO.setRequestSource(sourece);
            if ("crm".equals(sourece) && (stageUser = TokenUtils.getStageUser((HttpServletRequest)this.request)) != null) {
                sysActionLogVO.setAccount(stageUser.getAccountCode());
                sysActionLogVO.setCreateUserId(stageUser.getSysAccountId());
                sysActionLogVO.setCreateUserName(stageUser.getName());
                sysActionLogVO.setSysCompanyId(stageUser.getSysCompanyId());
                sysActionLogVO.setSysBrandId(stageUser.getBrandId());
            }
            sysActionLogVO.setButtonCode((String)jsonObject.get((Object)"buttonCode"));
            sysActionLogVO.setButtonName((String)jsonObject.get((Object)"buttonName"));
            sysActionLogVO.setMenuCode((String)jsonObject.get((Object)"menuCode"));
            sysActionLogVO.setMenuName((String)jsonObject.get((Object)"menuName"));
            sysActionLogVO.setWebhtmlUrl((String)jsonObject.get((Object)"webhtmlUrl"));
        }
        if (this.actionLogFeign != null) {
            this.actionLogFeign.insert(sysActionLogVO);
        }
    }

    private String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private JSONObject decrypt(String vString) {
        String decode = null;
        try {
            decode = URLDecoder.decode(vString, "UTF-8");
            if (StringUtil.isBlank((CharSequence)decode)) {
                return null;
            }
            Object parse = JSON.parse((String)decode);
            if (parse instanceof JSONObject) {
                return (JSONObject)parse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }
}

