package com.bizvane.connectorservice.entity.vo;

import com.bizvane.connectorservice.entity.base.BaseModel;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author xz
 * @date 2020/3/6 10:55
 **/

@Data
public class IntegralOrderRequestVo extends BaseModel{

    //会员微信openid
    private String openId;
    //订单状态 0未发货 1已发货 2已签收 3已关闭 4已退货 5退货中 6退货失败 7待审核 8.待支付
    private String orderStatus;
    //发货时间
    private Date sendGoodTime;
    //快递单号
    private String courierNo;
    //快递公司
    private String courierCompanyName;
    //会员卡号
    private String cardNo;

    private String memberCode;
    
    private String memberName;
    /**
     * 收货人姓名
     */
    private String consigneeName;

    /**
     * 收货人手机号
     */
    private String consigneePhone;

    /**
     *收货人：省
     */
    private String consigneeProvince;

    /**
     * 收货人：市
     */
    private String consigneeCity;

    /**
     * 收货人：区
     */
    private String consigneeArea;

    /**
     * 收货人：详细地址
     */
    private String consigneeDetailed;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 下单时间
     */
    private Date orderTime;
    //付款时间（现金支付才有）
    private Date payTime;

    /**
     * 总积分
     */
    private Integer costPoints;

    /**
     * 会员erpId
     */
    private String erpId;

    /**
     * 门店code
     */
    private String storeCode;
    
    private Integer storeId;

    /**
     * 订单明细
     */
    private List<IntegralOrderDetailRequestVo> orderDetail;

}
