package com.bizvane.connectorservice.entity.icrm;

import io.swagger.annotations.ApiModelProperty;
import lombok.ToString;
/**
 * @author admin
 * @date
 */
@ToString
public class AddIntegralRequestVO extends IcrmBaseModel {

    @ApiModelProperty(
            value = "VIP卡号",
            name = "vip_code",
            required = true,
            example = ""
    )
    private String vip_code;

    @ApiModelProperty(
            value = "流水积分",
            name = "integral",
            required = true,
            example = ""
    )
    private Integer integral;

    @ApiModelProperty(
            value = "来源",
            name = "source",
            required = true,
            example = "商帆固定值:999"
    )
    private Integer source;

    @ApiModelProperty(
            value = "关联单据",
            name = "relation_code",
            required = false,
            example = ""
    )
    private String relation_code;

    @ApiModelProperty(
            value = "新增时间",
            name = "add_time",
            required = false,
            example = ""
    )
    private String add_time;

    @ApiModelProperty(
            value = "顾客代码",
            name = "customer_code",
            required = false,
            example = "erpid"
    )
    private String customer_code;

    @ApiModelProperty(
            value = "渠道",
            name = "org_code",
            required = false,
            example = ""
    )
    private String org_code;

    @ApiModelProperty(
            value = "店铺",
            name = "shop_code",
            required = false,
            example = ""
    )
    private String shop_code;

    @ApiModelProperty(
            value = "备注",
            name = "remark",
            required = false,
            example = ""
    )
    private String remark;


    @ApiModelProperty(
            value = "品牌",
            name = "brand_code",
            required = false,
            example = ""
    )
    private String brand_code;

    @ApiModelProperty(
            value = "兑换的优惠券号",
            name = "coupon_code",
            required = false,
            example = ""
    )
    private String coupon_code;

    /**
     * 产生类型
     * 0-消费,1-调整,2-活动,3-兑换,4-积分抵现,5-顾客充值送,6-过期积分清零,
     * 7-积分变现,8-停卡,10：其他 12-积分签到 13-推荐送 14-完善顾客资料送积分
     * 15-开卡送积分 16-微信注册 17-评价送积分 18-问卷调查送积分 19-过期恢复积分
     * 20-积分定时清理 21-退货调整
     */
    private String create_type;

    public String getVip_code() {
        return vip_code;
    }

    public void setVip_code(String vip_code) {
        this.vip_code = vip_code;
    }

    public Integer getIntegral() {
        return integral;
    }

    public void setIntegral(Integer integral) {
        this.integral = integral;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public String getRelation_code() {
        return relation_code;
    }

    public void setRelation_code(String relation_code) {
        this.relation_code = relation_code;
    }

    public String getAdd_time() {
        return add_time;
    }

    public void setAdd_time(String add_time) {
        this.add_time = add_time;
    }

    public String getCustomer_code() {
        return customer_code;
    }

    public void setCustomer_code(String customer_code) {
        this.customer_code = customer_code;
    }

    public String getOrg_code() {
        return org_code;
    }

    public void setOrg_code(String org_code) {
        this.org_code = org_code;
    }

    public String getShop_code() {
        return shop_code;
    }

    public void setShop_code(String shop_code) {
        this.shop_code = shop_code;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String getBrand_code() {
        return brand_code;
    }

    @Override
    public void setBrand_code(String brand_code) {
        this.brand_code = brand_code;
    }

    public String getCoupon_code() {
        return coupon_code;
    }

    public void setCoupon_code(String coupon_code) {
        this.coupon_code = coupon_code;
    }

    public String getCreate_type() {
        return create_type;
    }

    public void setCreate_type(String create_type) {
        this.create_type = create_type;
    }
}
