/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.connectorservice.entity.req.wm;

import com.bizvane.connectorservice.constant.WmSystemConstant;
import com.bizvane.connectorservice.entity.param.CouponDefinitionParam;
import java.util.ArrayList;
import java.util.List;

public class CouponCreateReq {
    private Integer vid;
    private Integer vidType;
    private CouponBaseInfo baseInfo;
    private CouponSetting setting;
    private CouponSendRule sendRule;
    private CouponUseRule useRule;
    private CouponOtherSetting otherSetting;
    private CouponCreateInfo createInfo;

    public void buildCouponBaseInfo(CouponDefinitionParam param) {
        this.baseInfo = new CouponBaseInfo();
        this.baseInfo.setName(param.getCouponName());
        this.baseInfo.setBasicCouponTemplateIdList(param.getBasicCouponTemplateIdList());
    }

    public void buildCouponSetting(CouponDefinitionParam param) {
        int stock = Integer.MAX_VALUE;
        this.setting = new CouponSetting();
        this.setting.setStock(stock);
    }

    public void buildCouponSendRule(CouponDefinitionParam param) {
        int sendTimeType = 1;
        boolean isPayment = false;
        boolean merchantPublish = true;
        boolean customerDirectReceive = false;
        boolean isAcceptAllCrowd = true;
        int userTakeLimit = 100;
        boolean customerListPublish = true;
        boolean hasGiftLimit = false;
        boolean servicePublish = true;
        boolean activityPublish = true;
        boolean shoppingPublish = false;
        boolean enterpriseAssistant = true;
        this.sendRule = new CouponSendRule();
        this.sendRule.setSendTimeType(sendTimeType);
        this.sendRule.setIsPayment(isPayment);
        this.sendRule.setMerchantPublish(merchantPublish);
        this.sendRule.setCustomerDirectReceive(customerDirectReceive);
        this.sendRule.setIsAcceptAllCrowd(isAcceptAllCrowd);
        this.sendRule.setUserTakeLimit(userTakeLimit);
        this.sendRule.setCustomerListPublish(customerListPublish);
        this.sendRule.setHasGiftLimit(hasGiftLimit);
        this.sendRule.setServicePublish(servicePublish);
        this.sendRule.setActivityPublish(activityPublish);
        this.sendRule.setShoppingPublish(shoppingPublish);
        this.sendRule.setEnterpriseAssistant(enterpriseAssistant);
        if (null != param.getIsTransfer() && param.getIsTransfer().booleanValue()) {
            this.sendRule.setCanGift(Boolean.TRUE);
        } else {
            this.sendRule.setCanGift(Boolean.FALSE);
        }
    }

    public void buildCouponUseRule(CouponDefinitionParam param) {
        boolean isAllTimeUse = true;
        ArrayList<Integer> orderDeductList = new ArrayList<Integer>();
        this.useRule = new CouponUseRule();
        this.useRule.setIsAllTimeUse(isAllTimeUse);
        this.useRule.setOrderDeductList(orderDeductList);
        this.useRule.buildCouponUseValidDate(param);
    }

    public void buildCouponOtherSetting(CouponDefinitionParam param) {
        boolean isOpenMessage = false;
        this.otherSetting = new CouponOtherSetting();
        this.otherSetting.setExplain(param.getInfo());
        this.otherSetting.setIsOpenMessage(isOpenMessage);
    }

    public void buildCouponCreateInfo(CouponDefinitionParam param) {
        this.createInfo = new CouponCreateInfo();
        this.createInfo.setOperatorId(WmSystemConstant.WM_STSTEM_OPERATOR_ID);
    }

    public Integer getVid() {
        return this.vid;
    }

    public Integer getVidType() {
        return this.vidType;
    }

    public CouponBaseInfo getBaseInfo() {
        return this.baseInfo;
    }

    public CouponSetting getSetting() {
        return this.setting;
    }

    public CouponSendRule getSendRule() {
        return this.sendRule;
    }

    public CouponUseRule getUseRule() {
        return this.useRule;
    }

    public CouponOtherSetting getOtherSetting() {
        return this.otherSetting;
    }

    public CouponCreateInfo getCreateInfo() {
        return this.createInfo;
    }

    public void setVid(Integer vid) {
        this.vid = vid;
    }

    public void setVidType(Integer vidType) {
        this.vidType = vidType;
    }

    public void setBaseInfo(CouponBaseInfo baseInfo) {
        this.baseInfo = baseInfo;
    }

    public void setSetting(CouponSetting setting) {
        this.setting = setting;
    }

    public void setSendRule(CouponSendRule sendRule) {
        this.sendRule = sendRule;
    }

    public void setUseRule(CouponUseRule useRule) {
        this.useRule = useRule;
    }

    public void setOtherSetting(CouponOtherSetting otherSetting) {
        this.otherSetting = otherSetting;
    }

    public void setCreateInfo(CouponCreateInfo createInfo) {
        this.createInfo = createInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CouponCreateReq)) {
            return false;
        }
        CouponCreateReq other = (CouponCreateReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$vid = this.getVid();
        Integer other$vid = other.getVid();
        if (this$vid == null ? other$vid != null : !((Object)this$vid).equals(other$vid)) {
            return false;
        }
        Integer this$vidType = this.getVidType();
        Integer other$vidType = other.getVidType();
        if (this$vidType == null ? other$vidType != null : !((Object)this$vidType).equals(other$vidType)) {
            return false;
        }
        CouponBaseInfo this$baseInfo = this.getBaseInfo();
        CouponBaseInfo other$baseInfo = other.getBaseInfo();
        if (this$baseInfo == null ? other$baseInfo != null : !((Object)this$baseInfo).equals(other$baseInfo)) {
            return false;
        }
        CouponSetting this$setting = this.getSetting();
        CouponSetting other$setting = other.getSetting();
        if (this$setting == null ? other$setting != null : !((Object)this$setting).equals(other$setting)) {
            return false;
        }
        CouponSendRule this$sendRule = this.getSendRule();
        CouponSendRule other$sendRule = other.getSendRule();
        if (this$sendRule == null ? other$sendRule != null : !((Object)this$sendRule).equals(other$sendRule)) {
            return false;
        }
        CouponUseRule this$useRule = this.getUseRule();
        CouponUseRule other$useRule = other.getUseRule();
        if (this$useRule == null ? other$useRule != null : !((Object)this$useRule).equals(other$useRule)) {
            return false;
        }
        CouponOtherSetting this$otherSetting = this.getOtherSetting();
        CouponOtherSetting other$otherSetting = other.getOtherSetting();
        if (this$otherSetting == null ? other$otherSetting != null : !((Object)this$otherSetting).equals(other$otherSetting)) {
            return false;
        }
        CouponCreateInfo this$createInfo = this.getCreateInfo();
        CouponCreateInfo other$createInfo = other.getCreateInfo();
        return !(this$createInfo == null ? other$createInfo != null : !((Object)this$createInfo).equals(other$createInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CouponCreateReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $vid = this.getVid();
        result = result * 59 + ($vid == null ? 43 : ((Object)$vid).hashCode());
        Integer $vidType = this.getVidType();
        result = result * 59 + ($vidType == null ? 43 : ((Object)$vidType).hashCode());
        CouponBaseInfo $baseInfo = this.getBaseInfo();
        result = result * 59 + ($baseInfo == null ? 43 : ((Object)$baseInfo).hashCode());
        CouponSetting $setting = this.getSetting();
        result = result * 59 + ($setting == null ? 43 : ((Object)$setting).hashCode());
        CouponSendRule $sendRule = this.getSendRule();
        result = result * 59 + ($sendRule == null ? 43 : ((Object)$sendRule).hashCode());
        CouponUseRule $useRule = this.getUseRule();
        result = result * 59 + ($useRule == null ? 43 : ((Object)$useRule).hashCode());
        CouponOtherSetting $otherSetting = this.getOtherSetting();
        result = result * 59 + ($otherSetting == null ? 43 : ((Object)$otherSetting).hashCode());
        CouponCreateInfo $createInfo = this.getCreateInfo();
        result = result * 59 + ($createInfo == null ? 43 : ((Object)$createInfo).hashCode());
        return result;
    }

    public String toString() {
        return "CouponCreateReq(vid=" + this.getVid() + ", vidType=" + this.getVidType() + ", baseInfo=" + this.getBaseInfo() + ", setting=" + this.getSetting() + ", sendRule=" + this.getSendRule() + ", useRule=" + this.getUseRule() + ", otherSetting=" + this.getOtherSetting() + ", createInfo=" + this.getCreateInfo() + ")";
    }

    public static class CouponCycleUseRuleTimeSegment {
        private Integer beginHour;
        private Integer beginMinute;
        private Integer endHour;
        private Integer endMinute;

        public Integer getBeginHour() {
            return this.beginHour;
        }

        public Integer getBeginMinute() {
            return this.beginMinute;
        }

        public Integer getEndHour() {
            return this.endHour;
        }

        public Integer getEndMinute() {
            return this.endMinute;
        }

        public void setBeginHour(Integer beginHour) {
            this.beginHour = beginHour;
        }

        public void setBeginMinute(Integer beginMinute) {
            this.beginMinute = beginMinute;
        }

        public void setEndHour(Integer endHour) {
            this.endHour = endHour;
        }

        public void setEndMinute(Integer endMinute) {
            this.endMinute = endMinute;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CouponCycleUseRuleTimeSegment)) {
                return false;
            }
            CouponCycleUseRuleTimeSegment other = (CouponCycleUseRuleTimeSegment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$beginHour = this.getBeginHour();
            Integer other$beginHour = other.getBeginHour();
            if (this$beginHour == null ? other$beginHour != null : !((Object)this$beginHour).equals(other$beginHour)) {
                return false;
            }
            Integer this$beginMinute = this.getBeginMinute();
            Integer other$beginMinute = other.getBeginMinute();
            if (this$beginMinute == null ? other$beginMinute != null : !((Object)this$beginMinute).equals(other$beginMinute)) {
                return false;
            }
            Integer this$endHour = this.getEndHour();
            Integer other$endHour = other.getEndHour();
            if (this$endHour == null ? other$endHour != null : !((Object)this$endHour).equals(other$endHour)) {
                return false;
            }
            Integer this$endMinute = this.getEndMinute();
            Integer other$endMinute = other.getEndMinute();
            return !(this$endMinute == null ? other$endMinute != null : !((Object)this$endMinute).equals(other$endMinute));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CouponCycleUseRuleTimeSegment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $beginHour = this.getBeginHour();
            result = result * 59 + ($beginHour == null ? 43 : ((Object)$beginHour).hashCode());
            Integer $beginMinute = this.getBeginMinute();
            result = result * 59 + ($beginMinute == null ? 43 : ((Object)$beginMinute).hashCode());
            Integer $endHour = this.getEndHour();
            result = result * 59 + ($endHour == null ? 43 : ((Object)$endHour).hashCode());
            Integer $endMinute = this.getEndMinute();
            result = result * 59 + ($endMinute == null ? 43 : ((Object)$endMinute).hashCode());
            return result;
        }

        public String toString() {
            return "CouponCreateReq.CouponCycleUseRuleTimeSegment(beginHour=" + this.getBeginHour() + ", beginMinute=" + this.getBeginMinute() + ", endHour=" + this.getEndHour() + ", endMinute=" + this.getEndMinute() + ")";
        }
    }

    public static class CouponCycleUseRule {
        private List<Integer> weekDay;
        private List<CouponCycleUseRuleTimeSegment> timeSegment;

        public List<Integer> getWeekDay() {
            return this.weekDay;
        }

        public List<CouponCycleUseRuleTimeSegment> getTimeSegment() {
            return this.timeSegment;
        }

        public void setWeekDay(List<Integer> weekDay) {
            this.weekDay = weekDay;
        }

        public void setTimeSegment(List<CouponCycleUseRuleTimeSegment> timeSegment) {
            this.timeSegment = timeSegment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CouponCycleUseRule)) {
                return false;
            }
            CouponCycleUseRule other = (CouponCycleUseRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Integer> this$weekDay = this.getWeekDay();
            List<Integer> other$weekDay = other.getWeekDay();
            if (this$weekDay == null ? other$weekDay != null : !((Object)this$weekDay).equals(other$weekDay)) {
                return false;
            }
            List<CouponCycleUseRuleTimeSegment> this$timeSegment = this.getTimeSegment();
            List<CouponCycleUseRuleTimeSegment> other$timeSegment = other.getTimeSegment();
            return !(this$timeSegment == null ? other$timeSegment != null : !((Object)this$timeSegment).equals(other$timeSegment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CouponCycleUseRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Integer> $weekDay = this.getWeekDay();
            result = result * 59 + ($weekDay == null ? 43 : ((Object)$weekDay).hashCode());
            List<CouponCycleUseRuleTimeSegment> $timeSegment = this.getTimeSegment();
            result = result * 59 + ($timeSegment == null ? 43 : ((Object)$timeSegment).hashCode());
            return result;
        }

        public String toString() {
            return "CouponCreateReq.CouponCycleUseRule(weekDay=" + this.getWeekDay() + ", timeSegment=" + this.getTimeSegment() + ")";
        }
    }

    public static class CouponUseValidDate {
        private Integer useTimeType;
        private Long useStartTime;
        private Long useEndTime;
        private Integer validDays;
        private Integer useDelayDays;
        private Integer subUseTimeType;

        public Integer getUseTimeType() {
            return this.useTimeType;
        }

        public Long getUseStartTime() {
            return this.useStartTime;
        }

        public Long getUseEndTime() {
            return this.useEndTime;
        }

        public Integer getValidDays() {
            return this.validDays;
        }

        public Integer getUseDelayDays() {
            return this.useDelayDays;
        }

        public Integer getSubUseTimeType() {
            return this.subUseTimeType;
        }

        public void setUseTimeType(Integer useTimeType) {
            this.useTimeType = useTimeType;
        }

        public void setUseStartTime(Long useStartTime) {
            this.useStartTime = useStartTime;
        }

        public void setUseEndTime(Long useEndTime) {
            this.useEndTime = useEndTime;
        }

        public void setValidDays(Integer validDays) {
            this.validDays = validDays;
        }

        public void setUseDelayDays(Integer useDelayDays) {
            this.useDelayDays = useDelayDays;
        }

        public void setSubUseTimeType(Integer subUseTimeType) {
            this.subUseTimeType = subUseTimeType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CouponUseValidDate)) {
                return false;
            }
            CouponUseValidDate other = (CouponUseValidDate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$useTimeType = this.getUseTimeType();
            Integer other$useTimeType = other.getUseTimeType();
            if (this$useTimeType == null ? other$useTimeType != null : !((Object)this$useTimeType).equals(other$useTimeType)) {
                return false;
            }
            Long this$useStartTime = this.getUseStartTime();
            Long other$useStartTime = other.getUseStartTime();
            if (this$useStartTime == null ? other$useStartTime != null : !((Object)this$useStartTime).equals(other$useStartTime)) {
                return false;
            }
            Long this$useEndTime = this.getUseEndTime();
            Long other$useEndTime = other.getUseEndTime();
            if (this$useEndTime == null ? other$useEndTime != null : !((Object)this$useEndTime).equals(other$useEndTime)) {
                return false;
            }
            Integer this$validDays = this.getValidDays();
            Integer other$validDays = other.getValidDays();
            if (this$validDays == null ? other$validDays != null : !((Object)this$validDays).equals(other$validDays)) {
                return false;
            }
            Integer this$useDelayDays = this.getUseDelayDays();
            Integer other$useDelayDays = other.getUseDelayDays();
            if (this$useDelayDays == null ? other$useDelayDays != null : !((Object)this$useDelayDays).equals(other$useDelayDays)) {
                return false;
            }
            Integer this$subUseTimeType = this.getSubUseTimeType();
            Integer other$subUseTimeType = other.getSubUseTimeType();
            return !(this$subUseTimeType == null ? other$subUseTimeType != null : !((Object)this$subUseTimeType).equals(other$subUseTimeType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CouponUseValidDate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $useTimeType = this.getUseTimeType();
            result = result * 59 + ($useTimeType == null ? 43 : ((Object)$useTimeType).hashCode());
            Long $useStartTime = this.getUseStartTime();
            result = result * 59 + ($useStartTime == null ? 43 : ((Object)$useStartTime).hashCode());
            Long $useEndTime = this.getUseEndTime();
            result = result * 59 + ($useEndTime == null ? 43 : ((Object)$useEndTime).hashCode());
            Integer $validDays = this.getValidDays();
            result = result * 59 + ($validDays == null ? 43 : ((Object)$validDays).hashCode());
            Integer $useDelayDays = this.getUseDelayDays();
            result = result * 59 + ($useDelayDays == null ? 43 : ((Object)$useDelayDays).hashCode());
            Integer $subUseTimeType = this.getSubUseTimeType();
            result = result * 59 + ($subUseTimeType == null ? 43 : ((Object)$subUseTimeType).hashCode());
            return result;
        }

        public String toString() {
            return "CouponCreateReq.CouponUseValidDate(useTimeType=" + this.getUseTimeType() + ", useStartTime=" + this.getUseStartTime() + ", useEndTime=" + this.getUseEndTime() + ", validDays=" + this.getValidDays() + ", useDelayDays=" + this.getUseDelayDays() + ", subUseTimeType=" + this.getSubUseTimeType() + ")";
        }
    }

    public static class CouponCrowd {
        private String ruleContent;
        private String selectedData;

        public String getRuleContent() {
            return this.ruleContent;
        }

        public String getSelectedData() {
            return this.selectedData;
        }

        public void setRuleContent(String ruleContent) {
            this.ruleContent = ruleContent;
        }

        public void setSelectedData(String selectedData) {
            this.selectedData = selectedData;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CouponCrowd)) {
                return false;
            }
            CouponCrowd other = (CouponCrowd)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ruleContent = this.getRuleContent();
            String other$ruleContent = other.getRuleContent();
            if (this$ruleContent == null ? other$ruleContent != null : !this$ruleContent.equals(other$ruleContent)) {
                return false;
            }
            String this$selectedData = this.getSelectedData();
            String other$selectedData = other.getSelectedData();
            return !(this$selectedData == null ? other$selectedData != null : !this$selectedData.equals(other$selectedData));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CouponCrowd;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ruleContent = this.getRuleContent();
            result = result * 59 + ($ruleContent == null ? 43 : $ruleContent.hashCode());
            String $selectedData = this.getSelectedData();
            result = result * 59 + ($selectedData == null ? 43 : $selectedData.hashCode());
            return result;
        }

        public String toString() {
            return "CouponCreateReq.CouponCrowd(ruleContent=" + this.getRuleContent() + ", selectedData=" + this.getSelectedData() + ")";
        }
    }

    public static class CouponCreateInfo {
        private Long operatorId;
        private String source;

        public Long getOperatorId() {
            return this.operatorId;
        }

        public String getSource() {
            return this.source;
        }

        public void setOperatorId(Long operatorId) {
            this.operatorId = operatorId;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CouponCreateInfo)) {
                return false;
            }
            CouponCreateInfo other = (CouponCreateInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$operatorId = this.getOperatorId();
            Long other$operatorId = other.getOperatorId();
            if (this$operatorId == null ? other$operatorId != null : !((Object)this$operatorId).equals(other$operatorId)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            return !(this$source == null ? other$source != null : !this$source.equals(other$source));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CouponCreateInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $operatorId = this.getOperatorId();
            result = result * 59 + ($operatorId == null ? 43 : ((Object)$operatorId).hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            return result;
        }

        public String toString() {
            return "CouponCreateReq.CouponCreateInfo(operatorId=" + this.getOperatorId() + ", source=" + this.getSource() + ")";
        }
    }

    public static class CouponOtherSetting {
        private String explain;
        private List<Long> memberTagIds;
        private Boolean isOpenMessage;
        private Integer messageStockNum;
        private Boolean hasMemberTag;

        public String getExplain() {
            return this.explain;
        }

        public List<Long> getMemberTagIds() {
            return this.memberTagIds;
        }

        public Boolean getIsOpenMessage() {
            return this.isOpenMessage;
        }

        public Integer getMessageStockNum() {
            return this.messageStockNum;
        }

        public Boolean getHasMemberTag() {
            return this.hasMemberTag;
        }

        public void setExplain(String explain) {
            this.explain = explain;
        }

        public void setMemberTagIds(List<Long> memberTagIds) {
            this.memberTagIds = memberTagIds;
        }

        public void setIsOpenMessage(Boolean isOpenMessage) {
            this.isOpenMessage = isOpenMessage;
        }

        public void setMessageStockNum(Integer messageStockNum) {
            this.messageStockNum = messageStockNum;
        }

        public void setHasMemberTag(Boolean hasMemberTag) {
            this.hasMemberTag = hasMemberTag;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CouponOtherSetting)) {
                return false;
            }
            CouponOtherSetting other = (CouponOtherSetting)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$explain = this.getExplain();
            String other$explain = other.getExplain();
            if (this$explain == null ? other$explain != null : !this$explain.equals(other$explain)) {
                return false;
            }
            List<Long> this$memberTagIds = this.getMemberTagIds();
            List<Long> other$memberTagIds = other.getMemberTagIds();
            if (this$memberTagIds == null ? other$memberTagIds != null : !((Object)this$memberTagIds).equals(other$memberTagIds)) {
                return false;
            }
            Boolean this$isOpenMessage = this.getIsOpenMessage();
            Boolean other$isOpenMessage = other.getIsOpenMessage();
            if (this$isOpenMessage == null ? other$isOpenMessage != null : !((Object)this$isOpenMessage).equals(other$isOpenMessage)) {
                return false;
            }
            Integer this$messageStockNum = this.getMessageStockNum();
            Integer other$messageStockNum = other.getMessageStockNum();
            if (this$messageStockNum == null ? other$messageStockNum != null : !((Object)this$messageStockNum).equals(other$messageStockNum)) {
                return false;
            }
            Boolean this$hasMemberTag = this.getHasMemberTag();
            Boolean other$hasMemberTag = other.getHasMemberTag();
            return !(this$hasMemberTag == null ? other$hasMemberTag != null : !((Object)this$hasMemberTag).equals(other$hasMemberTag));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CouponOtherSetting;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $explain = this.getExplain();
            result = result * 59 + ($explain == null ? 43 : $explain.hashCode());
            List<Long> $memberTagIds = this.getMemberTagIds();
            result = result * 59 + ($memberTagIds == null ? 43 : ((Object)$memberTagIds).hashCode());
            Boolean $isOpenMessage = this.getIsOpenMessage();
            result = result * 59 + ($isOpenMessage == null ? 43 : ((Object)$isOpenMessage).hashCode());
            Integer $messageStockNum = this.getMessageStockNum();
            result = result * 59 + ($messageStockNum == null ? 43 : ((Object)$messageStockNum).hashCode());
            Boolean $hasMemberTag = this.getHasMemberTag();
            result = result * 59 + ($hasMemberTag == null ? 43 : ((Object)$hasMemberTag).hashCode());
            return result;
        }

        public String toString() {
            return "CouponCreateReq.CouponOtherSetting(explain=" + this.getExplain() + ", memberTagIds=" + this.getMemberTagIds() + ", isOpenMessage=" + this.getIsOpenMessage() + ", messageStockNum=" + this.getMessageStockNum() + ", hasMemberTag=" + this.getHasMemberTag() + ")";
        }
    }

    public static class CouponUseRule {
        private CouponUseValidDate useValidDate;
        private List<Integer> orderDeductList;
        private Boolean isAllTimeUse;
        private List<CouponCycleUseRule> cycleUseRule;

        public void buildCouponUseValidDate(CouponDefinitionParam param) {
            Byte validType_1 = 1;
            Byte validType_2 = 2;
            Byte validType_5 = 5;
            int subUseTimeType = 2;
            this.useValidDate = new CouponUseValidDate();
            if (param.getValidType() == validType_1) {
                this.useValidDate.setUseTimeType(1);
                this.useValidDate.setUseStartTime(param.getValidDateStart().getTime());
                this.useValidDate.setUseEndTime(param.getValidDateEnd().getTime());
            } else if (param.getValidType() == validType_2) {
                this.useValidDate.setUseTimeType(2);
                this.useValidDate.setValidDays(param.getValidDay());
                this.useValidDate.setUseDelayDays(0);
                this.useValidDate.setSubUseTimeType(subUseTimeType);
            } else if (param.getValidType() == validType_5) {
                this.useValidDate.setUseTimeType(2);
                this.useValidDate.setValidDays(param.getValidDay());
                this.useValidDate.setUseDelayDays(param.getDelayDay());
                this.useValidDate.setSubUseTimeType(subUseTimeType);
            }
        }

        public CouponUseValidDate getUseValidDate() {
            return this.useValidDate;
        }

        public List<Integer> getOrderDeductList() {
            return this.orderDeductList;
        }

        public Boolean getIsAllTimeUse() {
            return this.isAllTimeUse;
        }

        public List<CouponCycleUseRule> getCycleUseRule() {
            return this.cycleUseRule;
        }

        public void setUseValidDate(CouponUseValidDate useValidDate) {
            this.useValidDate = useValidDate;
        }

        public void setOrderDeductList(List<Integer> orderDeductList) {
            this.orderDeductList = orderDeductList;
        }

        public void setIsAllTimeUse(Boolean isAllTimeUse) {
            this.isAllTimeUse = isAllTimeUse;
        }

        public void setCycleUseRule(List<CouponCycleUseRule> cycleUseRule) {
            this.cycleUseRule = cycleUseRule;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CouponUseRule)) {
                return false;
            }
            CouponUseRule other = (CouponUseRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CouponUseValidDate this$useValidDate = this.getUseValidDate();
            CouponUseValidDate other$useValidDate = other.getUseValidDate();
            if (this$useValidDate == null ? other$useValidDate != null : !((Object)this$useValidDate).equals(other$useValidDate)) {
                return false;
            }
            List<Integer> this$orderDeductList = this.getOrderDeductList();
            List<Integer> other$orderDeductList = other.getOrderDeductList();
            if (this$orderDeductList == null ? other$orderDeductList != null : !((Object)this$orderDeductList).equals(other$orderDeductList)) {
                return false;
            }
            Boolean this$isAllTimeUse = this.getIsAllTimeUse();
            Boolean other$isAllTimeUse = other.getIsAllTimeUse();
            if (this$isAllTimeUse == null ? other$isAllTimeUse != null : !((Object)this$isAllTimeUse).equals(other$isAllTimeUse)) {
                return false;
            }
            List<CouponCycleUseRule> this$cycleUseRule = this.getCycleUseRule();
            List<CouponCycleUseRule> other$cycleUseRule = other.getCycleUseRule();
            return !(this$cycleUseRule == null ? other$cycleUseRule != null : !((Object)this$cycleUseRule).equals(other$cycleUseRule));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CouponUseRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CouponUseValidDate $useValidDate = this.getUseValidDate();
            result = result * 59 + ($useValidDate == null ? 43 : ((Object)$useValidDate).hashCode());
            List<Integer> $orderDeductList = this.getOrderDeductList();
            result = result * 59 + ($orderDeductList == null ? 43 : ((Object)$orderDeductList).hashCode());
            Boolean $isAllTimeUse = this.getIsAllTimeUse();
            result = result * 59 + ($isAllTimeUse == null ? 43 : ((Object)$isAllTimeUse).hashCode());
            List<CouponCycleUseRule> $cycleUseRule = this.getCycleUseRule();
            result = result * 59 + ($cycleUseRule == null ? 43 : ((Object)$cycleUseRule).hashCode());
            return result;
        }

        public String toString() {
            return "CouponCreateReq.CouponUseRule(useValidDate=" + this.getUseValidDate() + ", orderDeductList=" + this.getOrderDeductList() + ", isAllTimeUse=" + this.getIsAllTimeUse() + ", cycleUseRule=" + this.getCycleUseRule() + ")";
        }
    }

    public static class CouponSendRule {
        private Boolean hasUserTakeLimit;
        private Integer sendTimeType;
        private Long sendStartDate;
        private Long sendEndDate;
        private Boolean isPayment;
        private Boolean customerDirectReceive;
        private Long recommendStartTime;
        private Long recommendEndTime;
        private Boolean activityPublish;
        private Integer userTakeLimit;
        private CouponCrowd crowd;
        private Boolean canGift;
        private Boolean enterpriseAssistant;
        private Boolean isAcceptAllCrowd;
        private Boolean hasGiftLimit;
        private Integer giftCountLimit;
        private Boolean merchantPublish;
        private Boolean shoppingPublish;
        private Boolean customerListPublish;
        private Boolean servicePublish;
        private Integer storeLimitNum;
        private Boolean canShare;
        private Boolean canStoreLaunch;

        public Boolean getHasUserTakeLimit() {
            return this.hasUserTakeLimit;
        }

        public Integer getSendTimeType() {
            return this.sendTimeType;
        }

        public Long getSendStartDate() {
            return this.sendStartDate;
        }

        public Long getSendEndDate() {
            return this.sendEndDate;
        }

        public Boolean getIsPayment() {
            return this.isPayment;
        }

        public Boolean getCustomerDirectReceive() {
            return this.customerDirectReceive;
        }

        public Long getRecommendStartTime() {
            return this.recommendStartTime;
        }

        public Long getRecommendEndTime() {
            return this.recommendEndTime;
        }

        public Boolean getActivityPublish() {
            return this.activityPublish;
        }

        public Integer getUserTakeLimit() {
            return this.userTakeLimit;
        }

        public CouponCrowd getCrowd() {
            return this.crowd;
        }

        public Boolean getCanGift() {
            return this.canGift;
        }

        public Boolean getEnterpriseAssistant() {
            return this.enterpriseAssistant;
        }

        public Boolean getIsAcceptAllCrowd() {
            return this.isAcceptAllCrowd;
        }

        public Boolean getHasGiftLimit() {
            return this.hasGiftLimit;
        }

        public Integer getGiftCountLimit() {
            return this.giftCountLimit;
        }

        public Boolean getMerchantPublish() {
            return this.merchantPublish;
        }

        public Boolean getShoppingPublish() {
            return this.shoppingPublish;
        }

        public Boolean getCustomerListPublish() {
            return this.customerListPublish;
        }

        public Boolean getServicePublish() {
            return this.servicePublish;
        }

        public Integer getStoreLimitNum() {
            return this.storeLimitNum;
        }

        public Boolean getCanShare() {
            return this.canShare;
        }

        public Boolean getCanStoreLaunch() {
            return this.canStoreLaunch;
        }

        public void setHasUserTakeLimit(Boolean hasUserTakeLimit) {
            this.hasUserTakeLimit = hasUserTakeLimit;
        }

        public void setSendTimeType(Integer sendTimeType) {
            this.sendTimeType = sendTimeType;
        }

        public void setSendStartDate(Long sendStartDate) {
            this.sendStartDate = sendStartDate;
        }

        public void setSendEndDate(Long sendEndDate) {
            this.sendEndDate = sendEndDate;
        }

        public void setIsPayment(Boolean isPayment) {
            this.isPayment = isPayment;
        }

        public void setCustomerDirectReceive(Boolean customerDirectReceive) {
            this.customerDirectReceive = customerDirectReceive;
        }

        public void setRecommendStartTime(Long recommendStartTime) {
            this.recommendStartTime = recommendStartTime;
        }

        public void setRecommendEndTime(Long recommendEndTime) {
            this.recommendEndTime = recommendEndTime;
        }

        public void setActivityPublish(Boolean activityPublish) {
            this.activityPublish = activityPublish;
        }

        public void setUserTakeLimit(Integer userTakeLimit) {
            this.userTakeLimit = userTakeLimit;
        }

        public void setCrowd(CouponCrowd crowd) {
            this.crowd = crowd;
        }

        public void setCanGift(Boolean canGift) {
            this.canGift = canGift;
        }

        public void setEnterpriseAssistant(Boolean enterpriseAssistant) {
            this.enterpriseAssistant = enterpriseAssistant;
        }

        public void setIsAcceptAllCrowd(Boolean isAcceptAllCrowd) {
            this.isAcceptAllCrowd = isAcceptAllCrowd;
        }

        public void setHasGiftLimit(Boolean hasGiftLimit) {
            this.hasGiftLimit = hasGiftLimit;
        }

        public void setGiftCountLimit(Integer giftCountLimit) {
            this.giftCountLimit = giftCountLimit;
        }

        public void setMerchantPublish(Boolean merchantPublish) {
            this.merchantPublish = merchantPublish;
        }

        public void setShoppingPublish(Boolean shoppingPublish) {
            this.shoppingPublish = shoppingPublish;
        }

        public void setCustomerListPublish(Boolean customerListPublish) {
            this.customerListPublish = customerListPublish;
        }

        public void setServicePublish(Boolean servicePublish) {
            this.servicePublish = servicePublish;
        }

        public void setStoreLimitNum(Integer storeLimitNum) {
            this.storeLimitNum = storeLimitNum;
        }

        public void setCanShare(Boolean canShare) {
            this.canShare = canShare;
        }

        public void setCanStoreLaunch(Boolean canStoreLaunch) {
            this.canStoreLaunch = canStoreLaunch;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CouponSendRule)) {
                return false;
            }
            CouponSendRule other = (CouponSendRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$hasUserTakeLimit = this.getHasUserTakeLimit();
            Boolean other$hasUserTakeLimit = other.getHasUserTakeLimit();
            if (this$hasUserTakeLimit == null ? other$hasUserTakeLimit != null : !((Object)this$hasUserTakeLimit).equals(other$hasUserTakeLimit)) {
                return false;
            }
            Integer this$sendTimeType = this.getSendTimeType();
            Integer other$sendTimeType = other.getSendTimeType();
            if (this$sendTimeType == null ? other$sendTimeType != null : !((Object)this$sendTimeType).equals(other$sendTimeType)) {
                return false;
            }
            Long this$sendStartDate = this.getSendStartDate();
            Long other$sendStartDate = other.getSendStartDate();
            if (this$sendStartDate == null ? other$sendStartDate != null : !((Object)this$sendStartDate).equals(other$sendStartDate)) {
                return false;
            }
            Long this$sendEndDate = this.getSendEndDate();
            Long other$sendEndDate = other.getSendEndDate();
            if (this$sendEndDate == null ? other$sendEndDate != null : !((Object)this$sendEndDate).equals(other$sendEndDate)) {
                return false;
            }
            Boolean this$isPayment = this.getIsPayment();
            Boolean other$isPayment = other.getIsPayment();
            if (this$isPayment == null ? other$isPayment != null : !((Object)this$isPayment).equals(other$isPayment)) {
                return false;
            }
            Boolean this$customerDirectReceive = this.getCustomerDirectReceive();
            Boolean other$customerDirectReceive = other.getCustomerDirectReceive();
            if (this$customerDirectReceive == null ? other$customerDirectReceive != null : !((Object)this$customerDirectReceive).equals(other$customerDirectReceive)) {
                return false;
            }
            Long this$recommendStartTime = this.getRecommendStartTime();
            Long other$recommendStartTime = other.getRecommendStartTime();
            if (this$recommendStartTime == null ? other$recommendStartTime != null : !((Object)this$recommendStartTime).equals(other$recommendStartTime)) {
                return false;
            }
            Long this$recommendEndTime = this.getRecommendEndTime();
            Long other$recommendEndTime = other.getRecommendEndTime();
            if (this$recommendEndTime == null ? other$recommendEndTime != null : !((Object)this$recommendEndTime).equals(other$recommendEndTime)) {
                return false;
            }
            Boolean this$activityPublish = this.getActivityPublish();
            Boolean other$activityPublish = other.getActivityPublish();
            if (this$activityPublish == null ? other$activityPublish != null : !((Object)this$activityPublish).equals(other$activityPublish)) {
                return false;
            }
            Integer this$userTakeLimit = this.getUserTakeLimit();
            Integer other$userTakeLimit = other.getUserTakeLimit();
            if (this$userTakeLimit == null ? other$userTakeLimit != null : !((Object)this$userTakeLimit).equals(other$userTakeLimit)) {
                return false;
            }
            CouponCrowd this$crowd = this.getCrowd();
            CouponCrowd other$crowd = other.getCrowd();
            if (this$crowd == null ? other$crowd != null : !((Object)this$crowd).equals(other$crowd)) {
                return false;
            }
            Boolean this$canGift = this.getCanGift();
            Boolean other$canGift = other.getCanGift();
            if (this$canGift == null ? other$canGift != null : !((Object)this$canGift).equals(other$canGift)) {
                return false;
            }
            Boolean this$enterpriseAssistant = this.getEnterpriseAssistant();
            Boolean other$enterpriseAssistant = other.getEnterpriseAssistant();
            if (this$enterpriseAssistant == null ? other$enterpriseAssistant != null : !((Object)this$enterpriseAssistant).equals(other$enterpriseAssistant)) {
                return false;
            }
            Boolean this$isAcceptAllCrowd = this.getIsAcceptAllCrowd();
            Boolean other$isAcceptAllCrowd = other.getIsAcceptAllCrowd();
            if (this$isAcceptAllCrowd == null ? other$isAcceptAllCrowd != null : !((Object)this$isAcceptAllCrowd).equals(other$isAcceptAllCrowd)) {
                return false;
            }
            Boolean this$hasGiftLimit = this.getHasGiftLimit();
            Boolean other$hasGiftLimit = other.getHasGiftLimit();
            if (this$hasGiftLimit == null ? other$hasGiftLimit != null : !((Object)this$hasGiftLimit).equals(other$hasGiftLimit)) {
                return false;
            }
            Integer this$giftCountLimit = this.getGiftCountLimit();
            Integer other$giftCountLimit = other.getGiftCountLimit();
            if (this$giftCountLimit == null ? other$giftCountLimit != null : !((Object)this$giftCountLimit).equals(other$giftCountLimit)) {
                return false;
            }
            Boolean this$merchantPublish = this.getMerchantPublish();
            Boolean other$merchantPublish = other.getMerchantPublish();
            if (this$merchantPublish == null ? other$merchantPublish != null : !((Object)this$merchantPublish).equals(other$merchantPublish)) {
                return false;
            }
            Boolean this$shoppingPublish = this.getShoppingPublish();
            Boolean other$shoppingPublish = other.getShoppingPublish();
            if (this$shoppingPublish == null ? other$shoppingPublish != null : !((Object)this$shoppingPublish).equals(other$shoppingPublish)) {
                return false;
            }
            Boolean this$customerListPublish = this.getCustomerListPublish();
            Boolean other$customerListPublish = other.getCustomerListPublish();
            if (this$customerListPublish == null ? other$customerListPublish != null : !((Object)this$customerListPublish).equals(other$customerListPublish)) {
                return false;
            }
            Boolean this$servicePublish = this.getServicePublish();
            Boolean other$servicePublish = other.getServicePublish();
            if (this$servicePublish == null ? other$servicePublish != null : !((Object)this$servicePublish).equals(other$servicePublish)) {
                return false;
            }
            Integer this$storeLimitNum = this.getStoreLimitNum();
            Integer other$storeLimitNum = other.getStoreLimitNum();
            if (this$storeLimitNum == null ? other$storeLimitNum != null : !((Object)this$storeLimitNum).equals(other$storeLimitNum)) {
                return false;
            }
            Boolean this$canShare = this.getCanShare();
            Boolean other$canShare = other.getCanShare();
            if (this$canShare == null ? other$canShare != null : !((Object)this$canShare).equals(other$canShare)) {
                return false;
            }
            Boolean this$canStoreLaunch = this.getCanStoreLaunch();
            Boolean other$canStoreLaunch = other.getCanStoreLaunch();
            return !(this$canStoreLaunch == null ? other$canStoreLaunch != null : !((Object)this$canStoreLaunch).equals(other$canStoreLaunch));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CouponSendRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $hasUserTakeLimit = this.getHasUserTakeLimit();
            result = result * 59 + ($hasUserTakeLimit == null ? 43 : ((Object)$hasUserTakeLimit).hashCode());
            Integer $sendTimeType = this.getSendTimeType();
            result = result * 59 + ($sendTimeType == null ? 43 : ((Object)$sendTimeType).hashCode());
            Long $sendStartDate = this.getSendStartDate();
            result = result * 59 + ($sendStartDate == null ? 43 : ((Object)$sendStartDate).hashCode());
            Long $sendEndDate = this.getSendEndDate();
            result = result * 59 + ($sendEndDate == null ? 43 : ((Object)$sendEndDate).hashCode());
            Boolean $isPayment = this.getIsPayment();
            result = result * 59 + ($isPayment == null ? 43 : ((Object)$isPayment).hashCode());
            Boolean $customerDirectReceive = this.getCustomerDirectReceive();
            result = result * 59 + ($customerDirectReceive == null ? 43 : ((Object)$customerDirectReceive).hashCode());
            Long $recommendStartTime = this.getRecommendStartTime();
            result = result * 59 + ($recommendStartTime == null ? 43 : ((Object)$recommendStartTime).hashCode());
            Long $recommendEndTime = this.getRecommendEndTime();
            result = result * 59 + ($recommendEndTime == null ? 43 : ((Object)$recommendEndTime).hashCode());
            Boolean $activityPublish = this.getActivityPublish();
            result = result * 59 + ($activityPublish == null ? 43 : ((Object)$activityPublish).hashCode());
            Integer $userTakeLimit = this.getUserTakeLimit();
            result = result * 59 + ($userTakeLimit == null ? 43 : ((Object)$userTakeLimit).hashCode());
            CouponCrowd $crowd = this.getCrowd();
            result = result * 59 + ($crowd == null ? 43 : ((Object)$crowd).hashCode());
            Boolean $canGift = this.getCanGift();
            result = result * 59 + ($canGift == null ? 43 : ((Object)$canGift).hashCode());
            Boolean $enterpriseAssistant = this.getEnterpriseAssistant();
            result = result * 59 + ($enterpriseAssistant == null ? 43 : ((Object)$enterpriseAssistant).hashCode());
            Boolean $isAcceptAllCrowd = this.getIsAcceptAllCrowd();
            result = result * 59 + ($isAcceptAllCrowd == null ? 43 : ((Object)$isAcceptAllCrowd).hashCode());
            Boolean $hasGiftLimit = this.getHasGiftLimit();
            result = result * 59 + ($hasGiftLimit == null ? 43 : ((Object)$hasGiftLimit).hashCode());
            Integer $giftCountLimit = this.getGiftCountLimit();
            result = result * 59 + ($giftCountLimit == null ? 43 : ((Object)$giftCountLimit).hashCode());
            Boolean $merchantPublish = this.getMerchantPublish();
            result = result * 59 + ($merchantPublish == null ? 43 : ((Object)$merchantPublish).hashCode());
            Boolean $shoppingPublish = this.getShoppingPublish();
            result = result * 59 + ($shoppingPublish == null ? 43 : ((Object)$shoppingPublish).hashCode());
            Boolean $customerListPublish = this.getCustomerListPublish();
            result = result * 59 + ($customerListPublish == null ? 43 : ((Object)$customerListPublish).hashCode());
            Boolean $servicePublish = this.getServicePublish();
            result = result * 59 + ($servicePublish == null ? 43 : ((Object)$servicePublish).hashCode());
            Integer $storeLimitNum = this.getStoreLimitNum();
            result = result * 59 + ($storeLimitNum == null ? 43 : ((Object)$storeLimitNum).hashCode());
            Boolean $canShare = this.getCanShare();
            result = result * 59 + ($canShare == null ? 43 : ((Object)$canShare).hashCode());
            Boolean $canStoreLaunch = this.getCanStoreLaunch();
            result = result * 59 + ($canStoreLaunch == null ? 43 : ((Object)$canStoreLaunch).hashCode());
            return result;
        }

        public String toString() {
            return "CouponCreateReq.CouponSendRule(hasUserTakeLimit=" + this.getHasUserTakeLimit() + ", sendTimeType=" + this.getSendTimeType() + ", sendStartDate=" + this.getSendStartDate() + ", sendEndDate=" + this.getSendEndDate() + ", isPayment=" + this.getIsPayment() + ", customerDirectReceive=" + this.getCustomerDirectReceive() + ", recommendStartTime=" + this.getRecommendStartTime() + ", recommendEndTime=" + this.getRecommendEndTime() + ", activityPublish=" + this.getActivityPublish() + ", userTakeLimit=" + this.getUserTakeLimit() + ", crowd=" + this.getCrowd() + ", canGift=" + this.getCanGift() + ", enterpriseAssistant=" + this.getEnterpriseAssistant() + ", isAcceptAllCrowd=" + this.getIsAcceptAllCrowd() + ", hasGiftLimit=" + this.getHasGiftLimit() + ", giftCountLimit=" + this.getGiftCountLimit() + ", merchantPublish=" + this.getMerchantPublish() + ", shoppingPublish=" + this.getShoppingPublish() + ", customerListPublish=" + this.getCustomerListPublish() + ", servicePublish=" + this.getServicePublish() + ", storeLimitNum=" + this.getStoreLimitNum() + ", canShare=" + this.getCanShare() + ", canStoreLaunch=" + this.getCanStoreLaunch() + ")";
        }
    }

    public static class CouponSetting {
        private Integer stock;

        public Integer getStock() {
            return this.stock;
        }

        public void setStock(Integer stock) {
            this.stock = stock;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CouponSetting)) {
                return false;
            }
            CouponSetting other = (CouponSetting)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$stock = this.getStock();
            Integer other$stock = other.getStock();
            return !(this$stock == null ? other$stock != null : !((Object)this$stock).equals(other$stock));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CouponSetting;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $stock = this.getStock();
            result = result * 59 + ($stock == null ? 43 : ((Object)$stock).hashCode());
            return result;
        }

        public String toString() {
            return "CouponCreateReq.CouponSetting(stock=" + this.getStock() + ")";
        }
    }

    public static class CouponBaseInfo {
        private String name;
        private String merchantName;
        private List<Long> basicCouponTemplateIdList;

        public String getName() {
            return this.name;
        }

        public String getMerchantName() {
            return this.merchantName;
        }

        public List<Long> getBasicCouponTemplateIdList() {
            return this.basicCouponTemplateIdList;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setMerchantName(String merchantName) {
            this.merchantName = merchantName;
        }

        public void setBasicCouponTemplateIdList(List<Long> basicCouponTemplateIdList) {
            this.basicCouponTemplateIdList = basicCouponTemplateIdList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CouponBaseInfo)) {
                return false;
            }
            CouponBaseInfo other = (CouponBaseInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$merchantName = this.getMerchantName();
            String other$merchantName = other.getMerchantName();
            if (this$merchantName == null ? other$merchantName != null : !this$merchantName.equals(other$merchantName)) {
                return false;
            }
            List<Long> this$basicCouponTemplateIdList = this.getBasicCouponTemplateIdList();
            List<Long> other$basicCouponTemplateIdList = other.getBasicCouponTemplateIdList();
            return !(this$basicCouponTemplateIdList == null ? other$basicCouponTemplateIdList != null : !((Object)this$basicCouponTemplateIdList).equals(other$basicCouponTemplateIdList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CouponBaseInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $merchantName = this.getMerchantName();
            result = result * 59 + ($merchantName == null ? 43 : $merchantName.hashCode());
            List<Long> $basicCouponTemplateIdList = this.getBasicCouponTemplateIdList();
            result = result * 59 + ($basicCouponTemplateIdList == null ? 43 : ((Object)$basicCouponTemplateIdList).hashCode());
            return result;
        }

        public String toString() {
            return "CouponCreateReq.CouponBaseInfo(name=" + this.getName() + ", merchantName=" + this.getMerchantName() + ", basicCouponTemplateIdList=" + this.getBasicCouponTemplateIdList() + ")";
        }
    }
}

