package com.bizvane.connectorservice.interfaces.weimeng;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.out.wm.UpdateMemberInfoRequestVO;
import com.bizvane.connectorservice.entity.out.wm.VipLevelChangeVO;

/**
 * @author ljc
 * @date 2020/5/13 10:12
 **/

public interface WeiMengService {

    /**
     * 根据品牌id和code得到相关token
     * @param brandId
     * @return result<String>
     */
    Result getTokenBycode(Long brandId);

    /**
     * 根据refreshToken刷新accessToken
     * @param brandIds
     */
    void refreshToken(String brandIds);

    /**
     * 判断是否有微盟商城渠道
     * @param allChannelIds
     * @return
     */
    Boolean judgeAllChannelIds(String allChannelIds);

    /**
     * 获取会员wid
     * @param brandId
     * @param jsonRequest
     * @return long
     */
    Long getMemberWid(Long brandId, JSONObject jsonRequest);

    /**
     * 调用微盟修改会员信息
     * @param brandId
     * @param requestVO
     */
    void updateMemberInfo(Long brandId, UpdateMemberInfoRequestVO requestVO);

    /**
     * 调用微盟调整会员等级
     * @param vo
     * @throws Exception 异常
     */
    void changeMemberRank(VipLevelChangeVO vo) throws Exception;
}
