/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.jacksonutils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonUtil.class);
    private static final ObjectMapper MAPPER;
    public static String ymdhms;

    private static void configureParser(ObjectMapper mapper) {
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    public static <T> String bean2Json(T bean) {
        if (bean == null) {
            return null;
        }
        try {
            return MAPPER.writeValueAsString(bean);
        }
        catch (JsonProcessingException e) {
            LOG.error("JavaBean ===> JSON ERROR : {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> Map<String, Object> bean2Map(T bean) {
        return JacksonUtil.json2Map(JacksonUtil.bean2Json(bean));
    }

    public static <T> Map<String, String> bean2Map1(T bean) {
        return JacksonUtil.json2Map1(JacksonUtil.bean2Json(bean));
    }

    public static <T> T json2Obj(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            LOG.error("JSON ==> {} ERROR : {}", (Object)clazz.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T json2Objs(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            LOG.error("JSON ==> {} ERROR : {}", (Object)clazz.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }

    public static <T> Class[] json2Array(String json, Class<T>[] classes) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (Class[])MAPPER.readValue(json, classes.getClass());
        }
        catch (IOException e) {
            LOG.error("JSON ==> {} ERROR : {}", (Object)classes.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }

    public static String list2Json(List list) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return "";
        }
        try {
            return MAPPER.writeValueAsString((Object)list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Map<String, Object> json2Map(String json) {
        return JacksonUtil.json2Obj(json, HashMap.class);
    }

    public static Map<String, String> json2Map1(String json) {
        return JacksonUtil.json2Objs(json, HashMap.class);
    }

    public static List json2List(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (List)MAPPER.readValue(json, (TypeReference)new TypeReference<List>(){});
        }
        catch (IOException e) {
            LOG.error("JSON ==> List ERROR : {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> List<T> json2List(String json, Class<T> t) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{t});
            return (List)MAPPER.readValue(json, javaType);
        }
        catch (IOException e) {
            LOG.error("JSON ==> List ERROR : {}", (Object)e.getMessage());
            return null;
        }
    }

    static {
        ymdhms = "yyyy-MM-dd HH:mm:ss";
        MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().serializationInclusion(JsonInclude.Include.ALWAYS)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyyMMddHHmmss"));
        MAPPER.registerModule((Module)new JavaTimeModule());
        JacksonUtil.configureParser(MAPPER);
    }
}

