package com.bizvane.utils.enumutils;

public enum SysThirdBusinessEnum {

    PRODUCT_SYNC("productSync", "商品同步业务"),
    MBR_OPEN_CARD("mbrOpenCard", "会员开卡同步业务"),
    MBR_MEMBER_INFO_UPDATE("mbrMemberInfoUpdate", "会员资料修改同步业务"),
    MBR_LEVEL_UPDATE("mbrLevelUpdate", "会员等级同步业务"),
    MBR_INTEGRAL_UPDATE("mbrIntegralUpdate", "会员贡献值同步业务"),
    MBR_INTEGRAL_CHANGE_FLOW("mbrIntegralChangeFlow", "会员贡献值流水同步业务"),
    MBR_ORDER_SYNC("mbrOrderSync", "会员订单同步业务"),
    COUPON_DEFINITION_ADD("couponDefinitionAdd", "优惠券定义同步业务"),
    COUPON_SEND("couponSend", "优惠券发放同步业务"),
    COUPON_USED("couponUsed", "优惠券核销同步业务"),
    OTHER_BUSINESS("otherBusiness", "其他同步业务");

    private String typeCode;

    private String typeName;

    SysThirdBusinessEnum(String typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public static SysThirdBusinessEnum getSysThirdBusinessEnumByCode(String typeCode){
        for(SysThirdBusinessEnum sysThirdBusinessEnum : SysThirdBusinessEnum.values()){
            if (typeCode == sysThirdBusinessEnum.getTypeCode()) {
                return sysThirdBusinessEnum;
            }
        }
        return OTHER_BUSINESS;
    }
}
