/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.sm;

import com.bizvane.utils.sm.SM3Utils;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4Utils {
    private static final Logger log = LoggerFactory.getLogger(SM4Utils.class);
    private static final AtomicBoolean providerRegistered = new AtomicBoolean(false);
    private static final String PROVIDER_NAME = "BC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureProviderRegistered() {
        if (providerRegistered.get()) {
            if (Security.getProvider(PROVIDER_NAME) != null) {
                log.info("BC\u5df2\u6210\u529f\u6ce8\u518c");
                return;
            }
            providerRegistered.set(false);
            log.warn("BouncyCastle\u63d0\u4f9b\u8005\u5df2\u4e22\u5931\uff0c\u5c06\u5c1d\u8bd5\u91cd\u65b0\u6ce8\u518c");
        }
        Class<SM4Utils> clazz = SM4Utils.class;
        synchronized (SM4Utils.class) {
            if (providerRegistered.get()) {
                log.warn("BouncyCastle\u63d0\u4f9b\u8005\u5df2\u6ce8\u518c\uff0c\u5c06\u5ffd\u7565\u6b64\u64cd\u4f5c");
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                Provider existingProvider = Security.getProvider(PROVIDER_NAME);
                if (existingProvider == null) {
                    Security.addProvider((Provider)new BouncyCastleProvider());
                    log.info("\u5df2\u6210\u529f\u6ce8\u518cBouncyCastle\u63d0\u4f9b\u8005");
                } else if (!existingProvider.getClass().equals(BouncyCastleProvider.class)) {
                    Security.removeProvider(PROVIDER_NAME);
                    Security.addProvider((Provider)new BouncyCastleProvider());
                    log.warn("\u68c0\u6d4b\u5230\u4e0d\u517c\u5bb9\u7684BouncyCastle\u63d0\u4f9b\u8005\uff0c\u5df2\u66ff\u6362");
                } else {
                    log.info("BouncyCastle\u63d0\u4f9b\u8005\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6ce8\u518c");
                }
                Provider finalProvider = Security.getProvider(PROVIDER_NAME);
                if (finalProvider != null && finalProvider.getClass().equals(BouncyCastleProvider.class)) {
                    providerRegistered.set(true);
                    log.info("\u63d0\u4f9b\u8005\u9a8c\u8bc1\u6210\u529f");
                } else {
                    log.error("\u63d0\u4f9b\u8005\u6ce8\u518c\u540e\u9a8c\u8bc1\u5931\u8d25");
                }
            }
            catch (SecurityException e) {
                log.error("\u5b89\u5168\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u4fee\u6539\u63d0\u4f9b\u8005:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            catch (Exception e) {
                log.error("\u6ce8\u518cBouncyCastle\u63d0\u4f9b\u8005\u5931\u8d25:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            return;
        }
    }

    public static String decryptSM4(String encryptedData, String sm4Key) {
        try {
            SM4Utils.ensureProviderRegistered();
            Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", PROVIDER_NAME);
            SecretKeySpec keySpec = new SecretKeySpec(SM4Utils.hexStringToByteArray(sm4Key), "SM4");
            cipher.init(2, keySpec);
            byte[] data = SM4Utils.hexStringToByteArray(encryptedData);
            byte[] decryptedData = cipher.doFinal(data);
            return new String(decryptedData);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u62a5\u9519:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException(String.format("\u57fa\u4e8eSM4\u7b97\u6cd5\u89e3\u5bc6\u5f02\u5e38\uff0c\u5bc6\u6587\uff1a%s\uff0c\u5bc6\u94a5\uff1a%s", encryptedData, sm4Key), e);
        }
    }

    public static String encryptSM4(String data, String sm4Key) {
        try {
            SM4Utils.ensureProviderRegistered();
            Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", PROVIDER_NAME);
            SecretKeySpec keySpec = new SecretKeySpec(SM4Utils.hexStringToByteArray(sm4Key), "SM4");
            cipher.init(1, keySpec);
            byte[] encryptedData = cipher.doFinal(data.getBytes());
            return SM4Utils.byteArrayToHex(encryptedData);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u62a5\u9519:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException(String.format("\u57fa\u4e8eSM4\u7b97\u6cd5\u89e3\u5bc6\u5f02\u5e38\uff0c\u660e\u6587\uff1a%s\uff0c\u5bc6\u94a5\uff1a%s", data, sm4Key), e);
        }
    }

    public static String byteArrayToHex(byte[] bytes) {
        return SM3Utils.byteArrayToHex(bytes);
    }

    private static byte[] hexStringToByteArray(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }
}

