/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.autuconfig.traceController;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

@Aspect
public class TraceControllerAspect
implements Ordered {
    Logger logger = LoggerFactory.getLogger(TraceControllerAspect.class);
    protected final ApplicationContext context;
    protected final Environment env;
    protected final Pattern skipPattern;
    public final String ASPECT = "@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)";
    @Autowired
    HttpServletRequest request;

    @Around(value="@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        String methodName = pjp.getSignature().getName();
        if (this.skipPattern.matcher(methodName).matches()) {
            return pjp.proceed();
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        String applicationName = this.env.getProperty("spring.application.name");
        this.logger.info("\u5e94\u7528\u540d:{}", (Object)applicationName);
        this.logger.info("\u65b9\u6cd5\u540d:{}", (Object)methodName);
        this.logger.info("\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)this.request.getParameterMap()));
        Object result = null;
        try {
            Object object = result = pjp.proceed();
            return object;
        }
        catch (Exception e) {
            this.logger.info("\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
        finally {
            stopwatch.stop();
            this.logger.info("\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)result));
            this.logger.info("\u8017\u65f6:{}", (Object)stopwatch);
        }
    }

    public TraceControllerAspect(ApplicationContext context, Environment env, Pattern skipPattern) {
        this.context = context;
        this.env = env;
        this.skipPattern = skipPattern;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

