package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.po.CtrlAccountCompanyRelPo;
import com.bizvane.centercontrolservice.models.vo.CtrlAccountCompanyRelVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author liufq
 */
@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/ctrlAccountCompanyRelRpc")
public interface CtrlAccountCompanyRelServiceRpc {
    /**
     * 新增账号企业关系表(中台调用)
     *
     * @param po
     * @return
     * */
    @RequestMapping(value = "/addCtrlAccountCompanyRel",method = RequestMethod.POST)
    ResponseData<Long> addCtrlAccountCompanyRel(@RequestBody CtrlAccountCompanyRelPo po);

    /**
     * 删除账号企业关系表(中台调用)
     *
     * @param
     * @return
     * */
    @RequestMapping("/delCtrlAccountCompanyRel")
    ResponseData<Long> delCtrlAccountCompanyRel(@RequestBody CtrlAccountCompanyRelVo vo);

}
