/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.cdp.idmapping.service.service.impl;

import cn.hutool.core.util.ReflectUtil;
import com.bizvane.cdp.idmapping.facade.vo.req.CdpImportAddCustomerReqVO;
import com.bizvane.cdp.idmapping.service.domain.po.TCdpMembers1;
import com.bizvane.cdp.idmapping.service.domain.po.TCdpMembersMergeRecord1;
import com.bizvane.cdp.idmapping.service.service.ITCdpMembers1Service;
import com.bizvane.cdp.idmapping.service.service.ITCdpMembersMergeRecord1Service;
import com.bizvane.cdp.idmapping.service.service.impl.CdpImportAddCustomerService;
import com.bizvane.cdp.idmapping.service.util.ResponseUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CdpImportAddCustomerServiceImpl
implements CdpImportAddCustomerService {
    private static final Logger log = LoggerFactory.getLogger(CdpImportAddCustomerServiceImpl.class);
    @Autowired
    private ITCdpMembers1Service itCdpMembers1Service;
    @Autowired
    private ITCdpMembersMergeRecord1Service itCdpMembersMergeRecord1Service;

    @Override
    public ResponseData<String> importAdd(CdpImportAddCustomerReqVO reqVO) {
        Long sysCompanyId = reqVO.getSysCompanyId();
        Long sysBrandId = reqVO.getSysBrandId();
        String signId = reqVO.getSignId();
        List customerItemList = reqVO.getCustomerItemList();
        Field field = ReflectUtil.getField(TCdpMembers1.class, (String)signId);
        if (field == null) {
            String errMsg = signId + "\u5c5e\u6027\u4e0d\u5b58\u5728";
            log.info(errMsg);
            return ResponseUtil.getFailedMsg(errMsg);
        }
        List tCdpMembersList = customerItemList.stream().map(item -> {
            TCdpMembers1 members1 = new TCdpMembers1();
            members1.setBizOneId(item.getBizOneId());
            ReflectUtil.setFieldValue((Object)members1, (Field)field, (Object)item.getSignIdValue());
            members1.setMergeStatus(1);
            members1.setSysCompanyId(sysCompanyId);
            members1.setSysBrandId(sysBrandId);
            members1.setCDate(LocalDateTime.now());
            members1.setCreateDate(LocalDateTime.now());
            return members1;
        }).collect(Collectors.toList());
        List mergeRecordList = customerItemList.stream().map(item -> {
            TCdpMembersMergeRecord1 mergeRecord = new TCdpMembersMergeRecord1();
            mergeRecord.setNewBizOneId(item.getBizOneId());
            mergeRecord.setOldBizOneId(item.getBizOneId());
            mergeRecord.setValid(1);
            mergeRecord.setSignColumnName(signId);
            mergeRecord.setSignColumnValue(item.getSignIdValue());
            mergeRecord.setVersion(0);
            return mergeRecord;
        }).collect(Collectors.toList());
        this.itCdpMembers1Service.saveBatch(tCdpMembersList);
        this.itCdpMembersMergeRecord1Service.saveBatch(mergeRecordList);
        return ResponseUtil.getSuccessData("\u64cd\u4f5c\u6210\u529f");
    }
}

