/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.cdp.idmapping.service;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication(scanBasePackages={"com.bizvane.cdp.idmapping.service"})
@EnableFeignClients(basePackages={"com.bizvane.cdp.facade.feign"})
@EnableDiscoveryClient
@EnableSwagger2
@MapperScan(value={"com.bizvane.cdp.idmapping.service.mappers"})
public class CdpIdMappingServiceApplication {
    public static void main(String[] args) {
        SpringApplication.run(CdpIdMappingServiceApplication.class, (String[])args);
    }

    @LoadBalanced
    @Bean
    RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder) {
        return restTemplateBuilder.build();
    }
}

