package com.bizvane.cdp.algorithm.facade.interfaces;

import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpMbrAndEventTableColumnReqVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.cdp-algorithm.name}", path = "${feign.client.cdp-algorithm.path}/cdpMbrAndEventTableColumn")
@Api(value = "维护客户身份id同步操作会员表和事件表结构", tags = {"维护客户身份id同步操作会员表和事件表结构"})
public interface CdpMbrAndEventTableColumnFeign {

    @ApiOperation(value = "执行客户表和事件表变更表结构")
    @PostMapping("/execute")
    ResponseData<Boolean> execute(@RequestBody CdpMbrAndEventTableColumnReqVO reqVO);

}
