/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event.purchased.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.PurchasedTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.enterprise.ShareGoodsOperatorEnum;
import com.wmeimob.fastboot.bizvane.event.purchased.GoodPurchasedEvent;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.ShopCartPO;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.wrapper.BrowseWrapperService;
import com.wmeimob.fastboot.bizvane.vo.fegin.ShareGoodsOperatorRequestVO;
import com.wmeimob.fastboot.bizvane.vo.purchased.PurchasedEventVO;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class GoodPurchasedEnterpriseEvent
implements ApplicationListener<GoodPurchasedEvent> {
    private static final Logger log = LoggerFactory.getLogger(GoodPurchasedEnterpriseEvent.class);
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Autowired
    private BrowseWrapperService browseWrapperService;

    public void onApplicationEvent(GoodPurchasedEvent goodPurchasedEvent) {
        Integer type = goodPurchasedEvent.getType();
        PurchasedEventVO purchasedEventVO = goodPurchasedEvent.getPurchasedEventVO();
        Integer operator = 0;
        String operatorDesc = null;
        if (PurchasedTypeEnum.ADD.getCode().equals(type)) {
            operator = ShareGoodsOperatorEnum.PURCHASED_ADD.getCode();
            operatorDesc = ShareGoodsOperatorEnum.PURCHASED_ADD.getDesc();
        } else if (PurchasedTypeEnum.DEL.getCode().equals(type)) {
            operator = ShareGoodsOperatorEnum.PURCHASED_DEL.getCode();
            operatorDesc = ShareGoodsOperatorEnum.PURCHASED_DEL.getDesc();
        } else {
            operatorDesc = "\u76f4\u63a5return";
        }
        log.info("\u52a0\u8d2d\u4e8b\u4ef6:{},data:{}", (Object)operatorDesc, (Object)JSON.toJSONString((Object)((Object)goodPurchasedEvent)));
        if (operator == 0) {
            return;
        }
        List<ShopCartPO> shopCartPOs = purchasedEventVO.getShopCartPOs();
        for (ShopCartPO shopCartPO : shopCartPOs) {
            purchasedEventVO.setGoodsId(shopCartPO.getGoodsId());
            ShareGoodsOperatorRequestVO build = this.build(purchasedEventVO, operator);
            if (BrowseWrapperService.SHARE_FLAG != build.getShareFlag()) {
                log.info("\u975e\u5206\u4eab\u64cd\u4f5c\u4e0d\u63a8\u9001\u5546\u79c0shareGoodsRpc/insertShareGoodsOperator.do");
                continue;
            }
            this.bizvaneInterface.insertShareGoodsOperatorUrl(build);
        }
    }

    public ShareGoodsOperatorRequestVO build(PurchasedEventVO purchasedEventVO, Integer operator) {
        String memberCode = purchasedEventVO.getMemberCode();
        Integer merchantId = purchasedEventVO.getMerchantId();
        User user = purchasedEventVO.getUser();
        Integer goodsId = purchasedEventVO.getGoodsId();
        CompanyBrandRelationPO companyBrandRelationPO = this.companyBrandRelationService.getPOByMerchantId(merchantId);
        ShareGoodsOperatorRequestVO shareGoodsOperatorRequestVO = new ShareGoodsOperatorRequestVO();
        shareGoodsOperatorRequestVO.setOperator(operator);
        shareGoodsOperatorRequestVO.setMemberCode(memberCode);
        JSONObject singleMemberInfoJSON = this.bizvaneInterface.getSingleMemberInfoJSON(memberCode);
        Integer openCardGuideId = singleMemberInfoJSON.getInteger("openCardGuideId");
        Integer openCardStoreId = singleMemberInfoJSON.getInteger("openCardStoreId");
        Integer serviceStoreId = singleMemberInfoJSON.getInteger("serviceStoreId");
        Integer serviceGuideId = singleMemberInfoJSON.getInteger("serviceGuideId");
        GoodsPO goodsPO = this.goodsPOMapper.selectByPrimaryKey(goodsId);
        shareGoodsOperatorRequestVO.setSysCompanyId(companyBrandRelationPO.getCompanyId().longValue());
        shareGoodsOperatorRequestVO.setSysBrandId(companyBrandRelationPO.getBrandId().longValue());
        shareGoodsOperatorRequestVO.setSysStaffId(serviceGuideId.toString());
        shareGoodsOperatorRequestVO.setSysStoreId(serviceStoreId.toString());
        this.browseWrapperService.fillBrowse(shareGoodsOperatorRequestVO, user);
        shareGoodsOperatorRequestVO.setGoodsId(goodsId.longValue());
        shareGoodsOperatorRequestVO.setGoodsNo(goodsPO.getGoodsNo());
        shareGoodsOperatorRequestVO.setOperator(operator);
        return shareGoodsOperatorRequestVO;
    }
}

