/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.baison.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.baison.dto.requestVO.ParkSonConfig;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonResponseDTO;
import java.math.BigInteger;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BaiSonHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(BaiSonHttpUtil.class);
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyyMMddHHmmss";
    private static final String FORMAT = "json";

    public BaisonResponseDTO post(ParkSonConfig parkSonConfig, String data) {
        log.info("parkSonConfig:{}", (Object)JSON.toJSONString((Object)parkSonConfig));
        String key = parkSonConfig.getKey();
        String secret = parkSonConfig.getSecret();
        String version = parkSonConfig.getVersion();
        String accessToken = parkSonConfig.getAccessToken();
        String methodName = parkSonConfig.getMethodName();
        return this.getBaiSonE3Response(key, secret, version, accessToken, methodName, data);
    }

    public BaisonResponseDTO getBaiSonE3Response(String key, String secret, String version, String accessToken, String methodName, String data) {
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
        String datetime = BaiSonHttpUtil.getRequestTime();
        paramMap.put("key", key);
        paramMap.put("requestTime", datetime);
        paramMap.put("secret", secret);
        paramMap.put("version", version);
        paramMap.put("serviceType", methodName);
        paramMap.put("sign", this.getSign(paramMap, data));
        paramMap.put("data", data);
        paramMap.remove("secret");
        paramMap.put("format", FORMAT);
        String url = this.getReqStr(accessToken, paramMap);
        BaisonResponseDTO result = null;
        try {
            log.info("\u5b8c\u6574\u8bf7\u6c42:{}", (Object)url);
            JSONObject jsonObject = this.doGet(url, paramMap, methodName);
            result = (BaisonResponseDTO)JSONObject.parseObject((String)jsonObject.toJSONString(), BaisonResponseDTO.class);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u51fa\u9519\uff1a{}", (Object)e.getMessage());
        }
        log.info("E3\u8bf7\u6c42\uff1amethod\uff1a{}--param:{}", (Object)methodName, (Object)JSON.toJSONString((Object)data));
        return result;
    }

    private String getReqStr(String accessToken, Map<String, Object> param) {
        StringBuilder reqParamStr = new StringBuilder();
        if (param != null) {
            reqParamStr.append(accessToken).append("&");
            param.forEach((k, v) -> reqParamStr.append((String)k).append("=").append(v).append("&"));
        }
        return reqParamStr.deleteCharAt(reqParamStr.length() - 1).toString();
    }

    private JSONObject doGet(String url, Map<String, Object> param, String interfaceName) {
        JSONObject jsonObject = null;
        CloseableHttpClient client = HttpClients.createDefault();
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            list.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        String params = null;
        try {
            params = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(list, Consts.UTF_8));
            log.info("BaiSonHttpUtil#\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {}", new Object[]{interfaceName, url, JSONObject.toJSONString(param)});
            HttpGet httpGet = new HttpGet(url + "?" + params);
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity);
            response.close();
            jsonObject = JSONObject.parseObject((String)string);
            log.info("BaiSonHttpUtil#\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, url, JSONObject.toJSONString(param), string});
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObject;
    }

    private BaisonResponseDTO Okhttp(String url) throws Exception {
        Response response = null;
        Request request = new Request.Builder().get().tag((Object)this).url(url).build();
        log.info("\u8bf7\u6c42\u5b8c\u6574\u8def\u5f84\uff1a{}", (Object)request);
        try {
            OkHttpClient client = new OkHttpClient();
            response = client.newCall(request).execute();
        }
        catch (SocketTimeoutException client) {
            // empty catch block
        }
        String responseText = response.body().string();
        BaisonResponseDTO baisonResponseDTO = (BaisonResponseDTO)JSONObject.parseObject((String)responseText, BaisonResponseDTO.class);
        return baisonResponseDTO;
    }

    private String getSign(Map<String, Object> authMap, String data) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> m : authMap.entrySet()) {
            sb.append(m.getKey()).append("=").append(m.getValue()).append("&");
        }
        sb.append("data=").append(data);
        log.info("\u52a0\u5bc6\u53c2\u6570\uff1a{}", (Object)sb.toString());
        return this.getMD5(sb.toString());
    }

    private String getMD5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            log.warn("BaiSonHttpUtil#getMD5\u5f02\u5e38,\u8fd4\u56de\u7684\u52a0\u5bc6\u53c2\u6570\u7a7a:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static String getRequestTime() {
        LocalDateTime time = LocalDateTime.now(ZoneId.systemDefault());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS);
        return dateTimeFormatter.format(time);
    }
}

