/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.enums.newseckill;

import com.wmeimob.fastboot.bizvane.enums.newseckill.SeckillActivityType;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum SeckillActivityStatus {
    HAVE_NOT_START(0, "\u672a\u5f00\u59cb"),
    ON_GOING(1, "\u8fdb\u884c\u4e2d"),
    HAS_ENDED(2, "\u5df2\u7ed3\u675f"),
    HAS_BEEN_STOP(3, "\u5df2\u505c\u7528");

    private Integer code;
    private String message;

    private SeckillActivityStatus(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static String getMessageFromCode(Integer code) {
        SeckillActivityStatus[] values;
        for (SeckillActivityStatus value : values = SeckillActivityStatus.values()) {
            if (value.code != code) continue;
            return value.getMessage();
        }
        return null;
    }

    public static String calculateNextTime(Integer type, String rule, Long seckillBeginTime, Long seckillEndTime) {
        if (type == null || seckillBeginTime == null || seckillEndTime == null) {
            throw new MallCommonException("\u4f20\u5165\u53c2\u6570\u6709\u8bef");
        }
        Date currentTime = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentTime);
        long timeOffset = currentTime.getHours() * 60 * 60 + currentTime.getMinutes() * 60 + currentTime.getSeconds();
        SeckillActivityType currentType = SeckillActivityType.getByCode(type);
        ArrayList<Integer> list = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)rule)) {
            String[] split = rule.split(",");
            list = Arrays.stream(split).map(Integer::parseInt).sorted().collect(Collectors.toList());
        }
        String desc = null;
        switch (currentType) {
            case DAY: {
                desc = SeckillActivityStatus.getDateDecr(seckillBeginTime, timeOffset, 1, true);
                break;
            }
            case WEEK: {
                desc = SeckillActivityStatus.calculateNextTimeOfWeekOrMonth(calendar.get(7) - 1, seckillBeginTime, list, timeOffset, calendar.getActualMaximum(7));
                break;
            }
            case MONTH: {
                desc = SeckillActivityStatus.calculateNextTimeOfWeekOrMonth(calendar.get(5), seckillBeginTime, list, timeOffset, calendar.getActualMaximum(5));
                break;
            }
            case CUSTOMIZE: {
                break;
            }
        }
        return desc;
    }

    private static String getDateDecr(Long seckillBeginTime, long timeOffset, Integer interval, boolean isIn) {
        if (isIn && timeOffset <= seckillBeginTime) {
            return DateUtil.format(new Date(), DateUtil.ymd);
        }
        return DateUtil.format(DateUtil.addDay(new Date(), interval), DateUtil.ymd);
    }

    private static String calculateNextTimeOfWeekOrMonth(Integer currentDay, Long seckillBeginTime, List<Integer> list, long timeOffset, int maxDay) {
        Integer maxDayOfRule = list.get(list.size() - 1);
        if (currentDay > maxDayOfRule) {
            return SeckillActivityStatus.getDateDecr(seckillBeginTime, timeOffset, maxDay - currentDay + list.get(0), false);
        }
        for (int i = 0; i < list.size(); ++i) {
            Integer day = list.get(i);
            if (currentDay > day) continue;
            if (currentDay == day && currentDay < maxDayOfRule) {
                return SeckillActivityStatus.getDateDecr(seckillBeginTime, timeOffset, list.get(i + 1) - currentDay, true);
            }
            if (currentDay == day && currentDay == maxDayOfRule) {
                return SeckillActivityStatus.getDateDecr(seckillBeginTime, timeOffset, maxDay - maxDayOfRule + list.get(0), true);
            }
            if (currentDay < maxDayOfRule) {
                return SeckillActivityStatus.getDateDecr(seckillBeginTime, timeOffset, list.get(i) - currentDay, false);
            }
            if (currentDay <= maxDayOfRule) continue;
            return SeckillActivityStatus.getDateDecr(seckillBeginTime, timeOffset, maxDay - currentDay + list.get(0), false);
        }
        return null;
    }

    public static SeckillActivityStatus correctStatus(Integer type, String rule, Long seckillBeginTime, Long seckillEndTime, Integer disabled) {
        if (disabled == 1) {
            return HAS_BEEN_STOP;
        }
        SeckillActivityStatus currentStatus = null;
        if (type == null || seckillBeginTime == null || seckillEndTime == null) {
            throw new MallCommonException("\u4f20\u5165\u53c2\u6570\u6709\u8bef");
        }
        Date currentTime = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentTime);
        long timeOffset = currentTime.getHours() * 60 * 60 + currentTime.getMinutes() * 60 + currentTime.getSeconds();
        boolean inCurrentTime = timeOffset >= seckillBeginTime && timeOffset <= seckillEndTime;
        SeckillActivityType currentType = SeckillActivityType.getByCode(type);
        switch (currentType) {
            case DAY: {
                currentStatus = inCurrentTime ? ON_GOING : HAVE_NOT_START;
                break;
            }
            case WEEK: {
                String[] week = rule.split(",");
                int dayOfWeek = calendar.get(7) - 1;
                List<String> weekList = Arrays.asList(week);
                currentStatus = weekList.contains(dayOfWeek) && inCurrentTime ? ON_GOING : HAVE_NOT_START;
                break;
            }
            case MONTH: {
                String[] month = rule.split(",");
                int dayOfMonth = calendar.get(5);
                List<String> monthList = Arrays.asList(month);
                currentStatus = monthList.contains(dayOfMonth) && inCurrentTime ? ON_GOING : HAVE_NOT_START;
                break;
            }
            case CUSTOMIZE: {
                String[] date = rule.split("~");
                Date begin = DateUtil.parse(date[0], "yyyy-MM-dd");
                Date end = DateUtil.parse(date[1], "yyyy-MM-dd");
                end.setHours(24);
                end.setMinutes(0);
                end.setSeconds(0);
                if (currentTime.compareTo(end) > 0) {
                    currentStatus = HAS_ENDED;
                    break;
                }
                currentStatus = currentTime.compareTo(begin) < 0 && currentTime.compareTo(end) > 0 && inCurrentTime ? ON_GOING : HAVE_NOT_START;
                break;
            }
        }
        if (currentStatus == null) {
            throw new MallCommonException("\u4f20\u5165\u53c2\u6570\u6709\u8bef");
        }
        return currentStatus;
    }

    public static boolean checkStatus(SeckillActivityStatus activityStatus) {
        return HAS_ENDED.getCode().equals(activityStatus.getCode()) || HAS_BEEN_STOP.getCode().equals(activityStatus.getCode());
    }
}

