/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.utils.thirdpartyapi.skd361;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.po.IntegralMerchantOfflineConfigPO;
import com.wmeimob.fastboot.bizvane.service.config.IntegralMerchantOfflineConfigService;
import com.wmeimob.fastboot.bizvane.utils.RedisClient;
import com.wmeimob.fastboot.bizvane.utils.thirdpartyapi.skd361.ClientBasics;
import com.wmeimob.fastboot.bizvane.utils.thirdpartyapi.vo.ApiConfig361;
import com.wmeimob.fastboot.bizvane.utils.thirdpartyapi.vo.ApiConfigVO;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class Client361 {
    private static final Logger log = LoggerFactory.getLogger(Client361.class);
    @Autowired
    private IntegralMerchantOfflineConfigService integralMerchantOfflineConfigService;
    @Resource
    private RedisClient redisClient;

    public HashMap<String, String> doPostWithSuffixUrl(Integer merchantId, String suffixUrl, Map<String, String> parameters) {
        try {
            ApiConfig361 apiConfig361;
            ApiConfigVO apiConfig = this.getApiConfig(merchantId);
            if (apiConfig != null && (apiConfig361 = apiConfig.getApiConfig361()) != null) {
                parameters.put("appKey", apiConfig361.getAppKey());
                return this.invoke(apiConfig361.getInterfaceDomain(), suffixUrl, apiConfig361.getAppKey(), apiConfig361.getAppSecret(), "json", parameters);
            }
            return null;
        }
        catch (Exception e) {
            log.warn("Client361#doPostWithSuffixUrl\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public ApiConfigVO getApiConfig(Integer merchantId) {
        try {
            ApiConfigVO apiConfigVo = null;
            String redisConfig = (String)this.redisClient.get("361Config," + merchantId);
            log.info("\u4eceredis\u5f97\u5230\u7684\u914d\u7f6e:{}", (Object)redisConfig);
            if (StringUtils.isEmpty((Object)redisConfig)) {
                IntegralMerchantOfflineConfigPO offlineConfig = this.integralMerchantOfflineConfigService.getIntegralMerchantOfflineConfig(merchantId);
                String jsonContent = offlineConfig.getJsonContent();
                log.info("361\u914d\u7f6e:{}", (Object)jsonContent);
                if (StringUtils.isEmpty((Object)jsonContent)) {
                    log.info("Client361#getApiConfig#\u83b7\u53d6\u5230\u7684\u914d\u7f6e\u4e3a\u7a7a");
                    return null;
                }
                apiConfigVo = (ApiConfigVO)JSONObject.parseObject((String)jsonContent, ApiConfigVO.class);
                this.redisClient.set("361Config," + merchantId, jsonContent, 1800L);
                log.info("redis\u5f97\u5230\u914d\u7f6e\u4e3a\u7a7a\uff0c\u4ece\u6570\u636e\u5e93\u67e5\u8be2\u7684\u5230:{}", (Object)JSON.toJSONString((Object)apiConfigVo));
            } else {
                apiConfigVo = (ApiConfigVO)JSON.parseObject((String)redisConfig, ApiConfigVO.class);
            }
            return apiConfigVo;
        }
        catch (Exception e) {
            log.warn("Client361#getApiConfig\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public HashMap<String, String> invoke(String pUrl, String pMethod, String pUser, String pSession, String pFormat, Map<String, String> data) {
        log.info("invoke\u62fc\u63a5\u524d\u7684\u53c2\u6570:pUrl===>{},pMethod===>{},pUser===>{},pSession===>{},pFormat===>{},data===>{}", new Object[]{pUrl, pMethod, pUser, pSession, pFormat, JSON.toJSONString(data)});
        StringBuilder pStr = new StringBuilder();
        pStr.append("user=").append(ClientBasics.encodeURL(pUser, "UTF-8"));
        pStr.append("&").append("method=").append(ClientBasics.encodeURL(pMethod, "UTF-8"));
        if (!ClientBasics.isBlank(pFormat)) {
            pStr.append("&").append("format=").append(ClientBasics.encodeURL(pFormat, "UTF-8"));
        }
        StringBuilder str = new StringBuilder(pMethod + pSession);
        for (String key : data.keySet()) {
            str.append(key).append(data.get(key));
            pStr.append("&").append(key).append("=").append(ClientBasics.encodeURL(data.get(key), "UTF-8"));
        }
        String token = ClientBasics.strMd5(ClientBasics.strAsc(str.toString()));
        log.info("\u6392\u5e8f\u540e\u52a0\u5bc6\u540e:{}", (Object)token);
        pStr.append("&").append("token=").append(ClientBasics.encodeURL(token, "UTF-8"));
        return ClientBasics.rest(pUrl, pStr.toString(), "POST");
    }

    public static void main(String[] args) {
        Client361 client361 = new Client361();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appKey", "4342333343jfscrwer");
        HashMap<String, String> restJson = client361.invoke("http://39.98.78.95/361FxNew/api.rest", "IOpenAPI.GetOrder", "4342333343jfscrwer", "4423432jfscscewqe", "json", map);
        System.out.println(restJson);
    }
}

