/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralCashPayChannelEnum;
import com.wmeimob.fastboot.bizvane.enums.paygateway.PayGatewaySyncStatusEnum;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralConfigPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralWechatMchPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralConfigPO;
import com.wmeimob.fastboot.bizvane.po.IntegralConfigPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralUnionPayMchPO;
import com.wmeimob.fastboot.bizvane.po.IntegralWechatMchPO;
import com.wmeimob.fastboot.bizvane.service.IntegralCashPayService;
import com.wmeimob.fastboot.bizvane.service.skyworth.IntegralUnionPayService;
import com.wmeimob.fastboot.bizvane.service.skyworth.IntegralWeChatMchService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.skyworth.IntegralUnionPayMchVO;
import com.wmeimob.fastboot.bizvane.vo.skyworth.IntegralWeChatMchVO;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IntegralCashPayServiceImpl
implements IntegralCashPayService {
    private static final Logger log = LoggerFactory.getLogger(IntegralCashPayServiceImpl.class);
    @Resource
    private IntegralConfigPOMapper integralConfigPOMapper;
    @Resource
    private IntegralWechatMchPOMapper integralWechatMchPOMapper;
    @Autowired
    @Lazy
    private IntegralWeChatMchService integralWeChatMchService;
    @Autowired
    @Lazy
    private IntegralUnionPayService integralUnionPayService;

    @Override
    public void checkPayChannel(Integer merchantId, Integer cashPayChannel) {
        IntegralConfigPOExample integralConfigPOExample = new IntegralConfigPOExample();
        integralConfigPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<IntegralConfigPO> integralConfigPOS = this.integralConfigPOMapper.selectByExample(integralConfigPOExample);
        if (CollectionUtils.isEmpty(integralConfigPOS)) {
            log.info("\u65b0\u589e\u79ef\u5206\u5546\u57ce\u914d\u7f6e,\u5f53\u524d\u6e20\u9053:{}", (Object)cashPayChannel);
        } else {
            log.info("\u4fee\u6539\u79ef\u5206\u5546\u57ce\u914d\u7f6e,\u5f53\u524d\u6e20\u9053:{}", (Object)cashPayChannel);
        }
        if (IntegralCashPayChannelEnum.NO_CASH_PAY.getCode().equals(cashPayChannel) || cashPayChannel == null) {
            return;
        }
        IntegralWechatMchPO weChatMch = this.getWeChatMch(merchantId);
        if (IntegralCashPayChannelEnum.WECHAT_PAY.getCode().equals(cashPayChannel) && weChatMch == null) {
            throw new MallCommonException("\u5f53\u524d\u54c1\u724c\u672a\u914d\u7f6e\u5fae\u4fe1\u652f\u4ed8,\u4e0d\u53ef\u9009\u62e9");
        }
        IntegralUnionPayMchPO unionPayMch = this.getUnionPayMch(merchantId);
        if (IntegralCashPayChannelEnum.UNION_PAY.getCode().equals(cashPayChannel) && unionPayMch == null) {
            throw new MallCommonException("\u5f53\u524d\u54c1\u724c\u672a\u914d\u7f6e\u94f6\u8054\u652f\u4ed8,\u4e0d\u53ef\u9009\u62e9");
        }
    }

    @Override
    public IntegralWechatMchPO getWeChatMch(Integer merchantId) {
        return this.integralWeChatMchService.findByBrandId(merchantId);
    }

    @Override
    public IntegralUnionPayMchPO getUnionPayMch(Integer merchantId) {
        return this.integralUnionPayService.findByBrandId(merchantId);
    }

    @Override
    public ResponseData<IntegralConfig> modifyPayMch(IntegralConfig config) {
        Integer cashPayChannel = config.getCashPayChannel();
        Integer merchantId = config.getMerchantId();
        String appId = config.getAppId();
        ResponseData responseData = null;
        if (IntegralCashPayChannelEnum.NO_CASH_PAY.getCode().equals(cashPayChannel) || cashPayChannel == null) {
            responseData = ResponseUtil.getSuccessData(null);
            return responseData;
        }
        if (IntegralCashPayChannelEnum.WECHAT_PAY.getCode().equals(cashPayChannel)) {
            IntegralWechatMchPO weChatMch = this.getWeChatMch(merchantId);
            IntegralWeChatMchVO integralWeChatMchVO = config.getIntegralWeChatMchVO();
            integralWeChatMchVO.setMerchantId(merchantId);
            integralWeChatMchVO.setAppId(appId);
            responseData = weChatMch == null ? this.integralWeChatMchService.addMch(integralWeChatMchVO) : this.integralWeChatMchService.modifyMch(integralWeChatMchVO);
        }
        if (IntegralCashPayChannelEnum.UNION_PAY.getCode().equals(cashPayChannel)) {
            IntegralUnionPayMchPO unionPayMch = this.getUnionPayMch(merchantId);
            IntegralUnionPayMchVO integralUnionPayMchVO = config.getIntegralUnionPayMchVO();
            integralUnionPayMchVO.setMerchantId(merchantId);
            integralUnionPayMchVO.setAppId(appId);
            ResponseData<IntegralUnionPayMchPO> integralUnionPayMchPOResponseData = null;
            integralUnionPayMchPOResponseData = unionPayMch == null ? this.integralUnionPayService.addMch(integralUnionPayMchVO) : this.integralUnionPayService.modifyMch(integralUnionPayMchVO);
            int code = integralUnionPayMchPOResponseData.getCode();
            String message = integralUnionPayMchPOResponseData.getMessage();
            if (SysResponseEnum.SUCCESS.getCode() == code && unionPayMch != null) {
                IntegralUnionPayMchPO data = integralUnionPayMchPOResponseData.getData();
                this.integralUnionPayService.modifyMchStatus(data.getId(), PayGatewaySyncStatusEnum.UNSYNCHRONIZED);
            }
            responseData = new ResponseData();
            responseData.setCode(code);
            responseData.setMessage(message);
        }
        return responseData;
    }
}

