/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.vo.admin;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.vo.admin.SkusExportTempleVO;
import java.math.BigDecimal;
import org.springframework.util.StringUtils;

public class SkusExportCheck {
    public static boolean checkParam(SkusExportTempleVO skusExportTempleVO) {
        BigDecimal weightValue;
        BigDecimal volumeValue;
        String salePrice;
        String size;
        String errorMsg = null;
        String goodsNo = skusExportTempleVO.getGoodsNo();
        if (StringUtils.isEmpty((Object)goodsNo)) {
            errorMsg = "\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
            skusExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String skuNo = skusExportTempleVO.getSkuNo();
        if (StringUtils.isEmpty((Object)skuNo)) {
            errorMsg = "\u5546\u54c1SKU\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
            skusExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String skuName = skusExportTempleVO.getSkuName();
        if (StringUtils.isEmpty((Object)skuName)) {
            errorMsg = "\u5546\u54c1SKU\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
            skusExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String color = skusExportTempleVO.getColor();
        if (StringUtils.isEmpty((Object)color)) {
            skusExportTempleVO.setColor("\u65e0");
        }
        if (StringUtils.isEmpty((Object)(size = skusExportTempleVO.getSize()))) {
            skusExportTempleVO.setColor("\u5747\u7801");
        }
        if (StringUtils.isEmpty((Object)(salePrice = skusExportTempleVO.getSalePrice()))) {
            errorMsg = "\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a";
            skusExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        BigDecimal salePriceValue = SkusExportCheck.parseBigDecimal(salePrice);
        if (salePriceValue == null) {
            errorMsg = "\u8bf7\u586b\u5199\u6b63\u786e\u552e\u4ef7";
            skusExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String tagPrice = skusExportTempleVO.getTagPrice();
        if (StringUtils.isEmpty((Object)tagPrice)) {
            errorMsg = "\u540a\u724c\u4ef7\u4e0d\u80fd\u4e3a\u7a7a";
            skusExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        BigDecimal tagPriceValue = SkusExportCheck.parseBigDecimal(tagPrice);
        if (tagPriceValue == null) {
            errorMsg = "\u8bf7\u586b\u5199\u6b63\u786e\u540a\u724c\u4ef7";
            skusExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        int i = salePriceValue.compareTo(tagPriceValue);
        if (i == 1) {
            errorMsg = "\u552e\u4ef7\u4e0d\u80fd\u5927\u4e8e\u540a\u724c\u4ef7";
            skusExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String stock = skusExportTempleVO.getStock();
        if (StringUtils.isEmpty((Object)stock)) {
            errorMsg = "\u5e93\u5b58\u4e0d\u80fd\u4e3a\u7a7a";
            skusExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        Integer stockValue = SkusExportCheck.parseInteger(stock);
        if (stockValue == null || stockValue < 0) {
            errorMsg = "\u8bf7\u586b\u5199\u6b63\u786e\u5e93\u5b58";
            skusExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String volume = skusExportTempleVO.getVolume();
        if (StringUtils.isEmpty((Object)volume)) {
            skusExportTempleVO.setVolume("1");
        }
        if ((volumeValue = SkusExportCheck.parseBigDecimal(skusExportTempleVO.getVolume())) == null) {
            errorMsg = "\u8bf7\u586b\u5199\u6b63\u786e\u4f53\u79ef(m\u00b3)";
            skusExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String weight = skusExportTempleVO.getWeight();
        if (StringUtils.isEmpty((Object)weight)) {
            skusExportTempleVO.setWeight("1");
        }
        if ((weightValue = SkusExportCheck.parseBigDecimal(skusExportTempleVO.getWeight())) == null) {
            errorMsg = "\u8bf7\u586b\u5199\u6b63\u786e\u91cd\u91cf(kg)";
            skusExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static BigDecimal parseBigDecimal(String param) {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bigDecimal;
    }

    private static Integer parseInteger(String param) {
        Integer integer = null;
        try {
            integer = Double.valueOf(param).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return integer;
    }

    public static void main(String[] args) {
        String dd = "{\"color\":\"\u84dd\u8272\",\"goodsNo\":\"M0220000007\",\"index\":1,\"salePrice\":\"130.0\",\"size\":\"M\",\"skuName\":\"\u624b\u956f\",\"skuNo\":\"M0220000007F1\",\"stock\":\"20.0\",\"tagPrice\":\"129\",\"volume\":\"1.0\",\"weight\":\"1.0\"}";
        SkusExportTempleVO skusExportTempleVO = (SkusExportTempleVO)JSON.parseObject((String)dd, SkusExportTempleVO.class);
        SkusExportCheck.checkParam(skusExportTempleVO);
    }
}

