/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.event.RefundEvent;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class RefundEventListener
implements ApplicationListener<RefundEvent> {
    private static final Logger log = LoggerFactory.getLogger(RefundEventListener.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private OrdersMapper ordersMapper;

    public void onApplicationEvent(RefundEvent refundEvent) {
        this.scheduledThreadPoolExecutor.execute(() -> {
            block5: {
                try {
                    log.info("RefundEventListener#onApplicationEvent orderEvent:{}", (Object)JSON.toJSONString((Object)((Object)refundEvent)));
                    RefundOrder refundOrder = refundEvent.getRefundOrder();
                    RefundOrder puRefund = new RefundOrder();
                    BeanUtils.copyProperties((Object)refundOrder, (Object)puRefund);
                    Integer pushFlag = refundEvent.getPushFlag();
                    if (pushFlag == null || !pushFlag.equals(PushFlagEnum.REFUND.getPushFlag()) || puRefund == null || !puRefund.getRefundType().equals(1)) break block5;
                    log.info("\u9000\u6b3e\u63a8\u9001\u7ebf\u4e0b\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb----------->");
                    log.info("\u9000\u6b3e\u63a8\u9001\u7ebf\u4e0b\u4efb\u52a1:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)puRefund));
                    try {
                        Orders orders = new Orders();
                        orders.setOrderNo(refundOrder.getOrderNo());
                        orders = (Orders)this.ordersMapper.selectOne(orders);
                        if (orders != null) {
                            puRefund.setErpGuideId(orders.getErpGuideId());
                            puRefund.setErpGuideCode(orders.getErpGuideCode());
                            puRefund.setErpStoreCode(orders.getErpStoreCode());
                            puRefund.setErpStoreId(orders.getErpStoreId());
                            puRefund.setVipName(orders.getVipName());
                            puRefund.setErpId(orders.getErpId());
                            puRefund.setOfflineCardNo(orders.getOfflineCardNo());
                            log.info("\u4ec5\u9000\u6b3e\u5904\u7406\u5b8c\u6210\u6570\u636e:[{}]", JSON.toJSON((Object)puRefund));
                            this.bizvaneInterface.notifyRefundOrderInfo(puRefund);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u9000\u6b3e\u63a8\u9001\u7ebf\u4e0b\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.scheduledThreadPoolExecutor.execute(() -> {
            try {
                RefundOrder refundOrder = refundEvent.getRefundOrder();
                log.info("\u9000\u6b3e\u63a8\u9001\u4f01\u5fae");
                if (refundOrder != null) {
                    log.info("\u9000\u6b3e\u63a8\u9001\u4f01\u5fae\u4efb\u52a1:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)refundOrder));
                    Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey(refundOrder.getItems().get(0).getGoodsId());
                    refundOrder.getItems().get(0).setGoodsNo(goods.getGoodsNo());
                    if (refundOrder.getRefundType().equals(1)) {
                        log.info("\u9000\u6b3e\u63a8\u9001\u4f01\u5fae\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb----------->");
                        this.bizvaneInterface.notifyRefundQW(refundEvent.getRefundOrder());
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }
}

