/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpec;
import com.wmeimob.fastboot.bizvane.entity.MallLogs;
import com.wmeimob.fastboot.bizvane.entity.OrderPayTypeVO;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.GoodSpecEnum;
import com.wmeimob.fastboot.bizvane.enums.PayStatus;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.enums.PushToWhereEnum;
import com.wmeimob.fastboot.bizvane.event.OrderEvent;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.MallLogsService;
import com.wmeimob.fastboot.bizvane.utils.StringUtil;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class PaidOrderToOfflienListener
implements ApplicationListener<OrderEvent> {
    private static final Logger log = LoggerFactory.getLogger(PaidOrderToOfflienListener.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private OrdersMapper orderMapper;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Autowired
    private MallLogsService mallLogsService;
    @Autowired
    private GoodsSpecMapper goodsSpecMapper;

    public void onApplicationEvent(OrderEvent orderEvent) {
        this.scheduledThreadPoolExecutor.execute(() -> {
            block8: {
                try {
                    log.info("PaidOrderToOfflienListener#onApplicationEvent orderEvent:{}", (Object)JSON.toJSONString((Object)((Object)orderEvent)));
                    Orders orders = orderEvent.getOrders();
                    Orders puOrders = new Orders();
                    BeanUtils.copyProperties((Object)orders, (Object)puOrders);
                    Integer pushToWhere = orderEvent.getPushToWhere();
                    Integer pushFlag = orderEvent.getPushFlag();
                    Integer payStatus = orderEvent.getPayStatus();
                    if (payStatus == null || payStatus.equals(PayStatus.UN_PAY.getPayStatus())) {
                        return;
                    }
                    if (!pushFlag.equals(PushFlagEnum.PAID_ORDERS.getPushFlag()) && !pushFlag.equals(PushFlagEnum.ADD_PAID_ORDERS.getPushFlag()) || !pushToWhere.equals(PushToWhereEnum.TO_CONNECTOR_AND_FIRST_ORDER_QW.getPushToWhere()) && !pushToWhere.equals(PushToWhereEnum.TO_CONNECTOR_AND_NOT_FIRST_ORDER_QW.getPushToWhere()) && !pushToWhere.equals(PushToWhereEnum.TO_All.getPushToWhere()) && !pushToWhere.equals(PushToWhereEnum.TO_CONNECTOR.getPushToWhere())) break block8;
                    log.info("\u65b0\u589e\u8ba2\u5355\u63a8\u9001\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb----------->");
                    log.info("\u65b0\u589e\u8ba2\u5355\u63a8\u9001\u7ebf\u4e0b:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)orderEvent.getOrders()));
                    CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
                    companyBrandRelation.setMerchantId(puOrders.getMerchantId());
                    companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne(companyBrandRelation);
                    puOrders.setSysCompanyId(companyBrandRelation.getCompanyId());
                    String s = null;
                    MallLogs mallLogs = new MallLogs();
                    puOrders.getItems().forEach(e -> {
                        String[] split;
                        String specIds = e.getSpecIds();
                        String colorCode = null;
                        String sizeCode = null;
                        if (!StringUtils.isEmpty((Object)specIds) && (split = specIds.split(",")) != null && split.length > 0) {
                            for (int i = 0; i < split.length; ++i) {
                                String id = split[0];
                                GoodsSpec goodsSpec = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey(id);
                                Integer pid = goodsSpec.getPid();
                                if (pid == 0) continue;
                                GoodsSpec parent = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey(pid);
                                String specName = parent.getSpecName();
                                if (GoodSpecEnum.COLOR.getName().equals(specName)) {
                                    colorCode = goodsSpec.getSpecCode();
                                }
                                if (!GoodSpecEnum.SIZE.getName().equals(specName)) continue;
                                sizeCode = goodsSpec.getSpecCode();
                            }
                        }
                        String specCodes = StringUtil.append(colorCode, sizeCode);
                        e.setSpecCode(specCodes);
                    });
                    ArrayList<OrderPayTypeVO> orderPayTypeVOS = new ArrayList<OrderPayTypeVO>();
                    OrderPayTypeVO build = OrderPayTypeVO.builder().payType(orders.getPayType()).payMoney(orders.getPayAmount()).build();
                    orderPayTypeVOS.add(build);
                    puOrders.setPayTypes(orderPayTypeVOS);
                    log.info("\u5904\u7406\u5b8c\u6210\u8ba2\u5355\u6570\u636e:[{}]", JSON.toJSON((Object)puOrders));
                    try {
                        s = this.bizvaneInterface.notifyPaidOrderInfoOffLine(puOrders);
                    }
                    catch (Exception e2) {
                        mallLogs.setReason(e2.getMessage());
                        log.error("\u65b0\u589e\u8ba2\u5355\u63a8\u9001\u7ebf\u4e0b\u5931\u8d25:msg:[{}]_[{}]", (Object)e2.getMessage(), (Object)e2);
                        this.mallLogsService.doRecord(puOrders, mallLogs);
                    }
                    Orders od = new Orders();
                    od.setId(puOrders.getId());
                    if (!StringUtils.isEmpty((Object)s)) {
                        Integer result = "success".equals(s) ? 1 : 2;
                        od.setSynOfflineState(result);
                        if (od.getSynOfflineState() != null && od.getSynOfflineState().equals(2)) {
                            mallLogs.setReason("\u8c03\u7528\u8fde\u63a5\u5668\u63a5\u53e3\u5931\u8d25");
                            this.mallLogsService.doRecord(puOrders, mallLogs);
                        }
                    } else {
                        od.setSynOfflineState(2);
                    }
                    this.orderMapper.updateByPrimaryKeySelective(od);
                    log.info("\u65b0\u589e\u8ba2\u5355\u63a8\u9001\u7ebf\u4e0b\u6210\u529f");
                }
                catch (Exception e3) {
                    log.error(e3.getMessage(), (Throwable)e3);
                }
            }
        });
    }
}

