/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.baison.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.baison.dto.requestVO.CaiqiShiInformDetailVO;
import com.wmeimob.fastboot.baison.dto.requestVO.CaiqiShiOrderAddRequestVO;
import com.wmeimob.fastboot.baison.dto.requestVO.CaiqiShiRefundOrderRequestVO;
import com.wmeimob.fastboot.baison.dto.responseVO.CaiqishiResponseDTO;
import com.wmeimob.fastboot.baison.service.MC3OrderService;
import com.wmeimob.fastboot.bizvane.config.BizvaneProperties;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MC3OrderServiceImpl
implements MC3OrderService {
    private static final Logger log = LoggerFactory.getLogger(MC3OrderServiceImpl.class);
    @Resource
    private BizvaneProperties bizvaneProperties;

    @Override
    public CaiqishiResponseDTO orderPushMC3(Orders ordersE3) {
        log.info("==========\u8fdb\u5165\u5f69\u5947\u8bd7mc3\u8ba2\u5355\u6dfb\u52a0\u63a5\u53e3=========");
        log.info("MC3OrderServiceImpl_orderPushMC3:{}", (Object)JSON.toJSONString((Object)ordersE3));
        CaiqishiResponseDTO caiqishiResponseDTO = new CaiqishiResponseDTO();
        List<OrderItems> orderItemsList = ordersE3.getItems();
        if (!CollectionUtils.isEmpty(orderItemsList)) {
            CaiqiShiOrderAddRequestVO caiqiShiOrderAddRequestVO = new CaiqiShiOrderAddRequestVO();
            caiqiShiOrderAddRequestVO.setDealCode(ordersE3.getOrderNo());
            caiqiShiOrderAddRequestVO.setCode(ordersE3.getOrderNo());
            caiqiShiOrderAddRequestVO.setDate(DateUtil.interceptFormat(DateUtil.format(ordersE3.getGmtCreate(), DateUtil.ymdhms), DateUtil.ymdhms, DateUtil.ymd));
            ArrayList<CaiqiShiInformDetailVO> caiqiShiInformDetailVOList = new ArrayList<CaiqiShiInformDetailVO>();
            String url = this.bizvaneProperties.getCaiQiShiMc3Url() + caiqiShiOrderAddRequestVO.getServiceType();
            log.info("MC3OrderServiceImpl_url:{}", (Object)url);
            orderItemsList.stream().forEach(e -> {
                String skuNo = e.getGoodsSkuNo();
                Integer length = skuNo.length();
                String commodityCode = skuNo.substring(0, length - 6);
                String colourCode = skuNo.substring(length - 6, length - 3);
                String sizeCode = skuNo.substring(length - 3, length - 1);
                CaiqiShiInformDetailVO caiqiShiInformDetailVO = new CaiqiShiInformDetailVO();
                caiqiShiInformDetailVO.setCommodityCode(commodityCode);
                caiqiShiInformDetailVO.setColourCode(colourCode);
                caiqiShiInformDetailVO.setSizeCode(sizeCode);
                caiqiShiInformDetailVO.setCount(e.getSaleQuantity());
                caiqiShiInformDetailVO.setPrice(e.getWepayAmount().intValue());
                caiqiShiInformDetailVOList.add(caiqiShiInformDetailVO);
            });
            caiqiShiOrderAddRequestVO.setRemark(ordersE3.getUserName() + ordersE3.getShippingMobile() + ordersE3.getShippingProvince() + ordersE3.getShippingCity() + ordersE3.getShippingDistrict() + ordersE3.getShippingAddress());
            caiqiShiOrderAddRequestVO.setInformDetail(caiqiShiInformDetailVOList);
            log.info("MC3OrderServiceImpl_caiqiShiOrderAddRequestVO:{}", (Object)JSON.toJSONString((Object)caiqiShiOrderAddRequestVO));
            Map beanMap = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)caiqiShiOrderAddRequestVO), Map.class);
            beanMap.remove("serviceType");
            log.info("\u8f6c\u5316\u7684map\u5bf9\u8c61\uff1a{}", (Object)beanMap.toString());
            JSONObject data = (JSONObject)JSON.parseObject((String)this.HttpPostWithJson(url, JSON.toJSONString((Object)beanMap)), JSONObject.class);
            log.info("\u63a8\u9001\u5f69\u5947\u8bd7\u8ba2\u5355\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)data));
            caiqishiResponseDTO.setSuccess((Boolean)data.get((Object)"success"));
        }
        return caiqishiResponseDTO;
    }

    @Override
    public CaiqishiResponseDTO refundOrderPushMC3(Orders currentOrders) {
        CaiqishiResponseDTO caiqishiResponseDTO = new CaiqishiResponseDTO();
        caiqishiResponseDTO.setSuccess(false);
        log.info("==========\u8fdb\u5165\u5f69\u5947\u8bd7mc3\u9000\u5355\u8bb0\u5f55\u63a5\u53e3=========");
        log.info("MC3OrderServiceImpl_refundOrderPushMC3:{}", (Object)JSON.toJSONString((Object)currentOrders));
        String url = this.bizvaneProperties.getCaiQiShiMc3Url() + "/cancel/order";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("code", currentOrders.getOrderNo());
        JSONObject jsonObject = this.doGet(url, param, "2\u914d\u8d27\u901a\u77e5\u5355\u53d6\u6d88");
        Boolean isFlag = jsonObject.getBoolean("success");
        log.info("/cancel/order\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)jsonObject);
        log.info("isFlag:{}", (Object)isFlag);
        if (!isFlag.booleanValue()) {
            log.info("\u8fdb\u5165\u9000\u6b3e\u5199\u5165\u6d41\u7a0b");
            url = this.bizvaneProperties.getCaiQiShiMc3Url() + "/create/retailReturn";
            ArrayList<CaiqiShiInformDetailVO> caiqiShiInformDetailVOList = new ArrayList<CaiqiShiInformDetailVO>();
            CaiqiShiRefundOrderRequestVO caiqiShiRefundOrderRequestVO = new CaiqiShiRefundOrderRequestVO();
            caiqiShiRefundOrderRequestVO.setDate(DateUtil.interceptFormat(DateUtil.format(currentOrders.getGmtCreate(), DateUtil.ymdhms), DateUtil.ymdhms, DateUtil.ymd));
            caiqiShiRefundOrderRequestVO.setDealCode(currentOrders.getOrderNo());
            currentOrders.getItems().stream().forEach(e -> {
                String skuNo = e.getGoodsSkuNo();
                String commodityCode = skuNo.substring(0, 6);
                String colourCode = skuNo.substring(6, 9);
                String sizeCode = skuNo.substring(9, 12);
                CaiqiShiInformDetailVO caiqiShiInformDetailVO = new CaiqiShiInformDetailVO();
                caiqiShiInformDetailVO.setColourCode(colourCode);
                caiqiShiInformDetailVO.setCommodityCode(commodityCode);
                caiqiShiInformDetailVO.setCount(e.getSaleQuantity());
                caiqiShiInformDetailVO.setPrice(e.getWepayAmount().intValue());
                caiqiShiInformDetailVO.setSizeCode(sizeCode);
                caiqiShiInformDetailVOList.add(caiqiShiInformDetailVO);
            });
            caiqiShiRefundOrderRequestVO.setRemark(currentOrders.getUserName() + currentOrders.getShippingMobile() + currentOrders.getShippingAddress());
            caiqiShiRefundOrderRequestVO.setInformDetail(caiqiShiInformDetailVOList);
            log.info("MC3OrderServiceImpl_caiqiShiRefundOrderRequestVO:{}", (Object)JSON.toJSONString((Object)caiqiShiRefundOrderRequestVO));
            Map beanMap = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)caiqiShiRefundOrderRequestVO), Map.class);
            beanMap.remove("serviceType");
            log.info("\u8f6c\u5316\u7684map\u5bf9\u8c61\uff1a{}", (Object)beanMap.toString());
            String result = this.HttpPostWithJson(url, JSON.toJSONString((Object)beanMap));
            log.info("\u63a8\u9001\u5f69\u5947\u8bd7\u9000\u6b3e\u8ba2\u5355\u8fd4\u56de\uff1a{}", (Object)result);
            JSONObject data = (JSONObject)JSON.parseObject((String)result, JSONObject.class);
            caiqishiResponseDTO.setSuccess((Boolean)data.get((Object)"success"));
        }
        return caiqishiResponseDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String HttpPostWithJson(String url, String json) {
        String returnValue = "\u8fd9\u662f\u9ed8\u8ba4\u8fd4\u56de\u503c\uff0c\u63a5\u53e3\u8c03\u7528\u5931\u8d25";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            log.info("json\u53c2\u6570:{},url:{}", (Object)json, (Object)url);
            StringEntity requestEntity = new StringEntity(json, "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity((HttpEntity)requestEntity);
            returnValue = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
            log.info("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)returnValue);
        }
        catch (Exception e) {
            log.error("\u5f69\u5947\u8bd7\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return returnValue;
    }

    private JSONObject doGet(String url, Map<String, Object> param, String interfaceName) {
        JSONObject jsonObject = null;
        CloseableHttpClient client = HttpClients.createDefault();
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            list.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        String params = null;
        try {
            params = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(list, Consts.UTF_8));
            HttpGet httpGet = new HttpGet(url + "?" + params);
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity);
            response.close();
            jsonObject = JSONObject.parseObject((String)string);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, url, JSONObject.toJSONString(param), string});
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObject;
    }
}

