package com.bizvane.basic.feign.model.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NonNull;
import lombok.Setter;

import javax.validation.constraints.NotBlank;

/**
 * 修改密码
 */
@Getter
@Setter
public class TSysAccountChangePasswordReq {

    @ApiModelProperty(value = "账户code")
    @NotBlank(message = "账号不能为空")
    private String accountCode;
    @ApiModelProperty(value = "旧密码")
    private String oldPassword;
    @ApiModelProperty(value = "新密码")
    private String newPassword;
    @ApiModelProperty(value = "类型（1修改密码 2重置密码）")
    @NonNull
    private Integer type;


}
