package com.bizvane.basic.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 员工
 */
@Data
public class TBasicStaffVo implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "pkid")
    private Long id;

    @ApiModelProperty(value = "员工code")
    private String staffCode;

    @ApiModelProperty(value = "员工名称")
    private String staffName;

    @ApiModelProperty(value = "员工类型(1-内部员工  2-委外员工)")
    private Integer staffType;

    @ApiModelProperty(value = "员工编码")
    private String staffNo;

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty(value = "手机号集合")
    private List<String> phoneList;

    @ApiModelProperty(value = "身份证号")
    private String idCard;

    @ApiModelProperty(value = "组织code")
    private String orgCode;
    private String orgName;

    @ApiModelProperty(value = "状态：0=离职；1=在职  2=退休")
    private Integer status;

    @ApiModelProperty(value = "创建人id")
    private String createUserCode;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "创建日期")
    private Date createDate;

    @ApiModelProperty(value = "修改人id")
    private String modifiedUserCode;

    @ApiModelProperty(value = "修改人")
    private String modifiedUserName;

    @ApiModelProperty(value = "修改时间")
    private Date modifiedDate;

    @ApiModelProperty(value = "数据有效性：1=有效；0=无效")
    private Boolean valid;

    @ApiModelProperty(value = "备注")
    private String remark;


    @ApiModelProperty(value = "组织")
    private String org;

    @ApiModelProperty("员工来源:   1-会员运营平台、2-总线")
    private Integer staffSource;



}
