package com.bizvane.basic.feign.model.rsp.approve;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

@Getter
@Setter
@ApiModel
public class QueryApproveTaskNodeListResponseVO {

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("审批任务code")
    private String taskCode;

    @ApiModelProperty("审批配置节点code")
    private String approveNodeCode;

    @ApiModelProperty("节点code")
    private String nodeCode;

    @ApiModelProperty("节点名称")
    private String nodeName;

    @ApiModelProperty("节点序号")
    private Integer nodeSort;

    @ApiModelProperty("审批人code（多个用逗号隔开）")
    private String approvers;

    @ApiModelProperty("审批状态（0等待前置审核 1审核中 2审核通过 3审核拒绝 4审核超时 5审核撤销）")
    private Integer status;

    @ApiModelProperty("审核人code")
    private String approveUserCode;

    @ApiModelProperty("审核人")
    private String approveUserName;

    @ApiModelProperty("审核时间")
    private Date approveTime;

    @ApiModelProperty("创建人id")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建时间")
    private Date createDate;

    @ApiModelProperty("修改人id")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private Date modifiedDate;

    @ApiModelProperty("审核备注")
    private String remark;
}
