package com.bizvane.basic.feign.model.req.approve;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Getter
@Setter
@ApiModel(value = "审批任务审批VO")
public class ApproveTaskAuditVO {

    @ApiModelProperty("关联业务ID（业务数据唯一code）")
    @NotBlank(message = "关联业务ID不能为空")
    private String refBusinessId;

    @NotNull(message = "审批状态不能为空")
    @ApiModelProperty(value = "审批状态（1审核中 2审核通过 3审核拒绝 4审核超时 5审核撤销）", required = true)
    private Integer status;

    @ApiModelProperty(value = "审批备注")
    private String remark;

    @ApiModelProperty(value = "审批人code")
    @NotBlank(message = "审批人不能为空")
    private String approveUserCode;

    @ApiModelProperty(value = "审批人")
    private String approveUserName;


}
