package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.vo.TBasicOrgTreeVo;
import com.bizvane.basic.feign.model.vo.TBasicOrgVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBasicOrg")
@Api(value = "工会组织RPC")
public interface BasicOrgRpcFeign {

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(value = "组织列表")
    ResponseData<List<TBasicOrgTreeVo>> list(@RequestBody TBasicOrgVo req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "添加组织")
    ResponseData<Boolean> save(@RequestBody TBasicOrgVo req);

    @RequestMapping(value = "/modify", method = RequestMethod.POST)
    @ApiOperation(value = "编辑组织")
    ResponseData<Boolean> modify(@RequestBody TBasicOrgVo req);

    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    @ApiOperation(value = "详情")
    ResponseData<TBasicOrgVo> detail(@RequestBody TBasicOrgVo req);

    @RequestMapping(value = "/childrenList", method = RequestMethod.POST)
    @ApiOperation(value = "根据组织code查询组织所有子集")
    ResponseData<List<TBasicOrgVo>> childrenList(@RequestBody TBasicOrgVo req);

}
