package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.req.TBasicMerchantPageReq;
import com.bizvane.basic.feign.model.req.TBasicMerchantSearchPageReq;
import com.bizvane.basic.feign.model.vo.TBasicMerchantVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBasicMerchant")
@Api(value = "商户RPC")
public interface BasicMerchantRpcFeign {

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "分页条件查询列表")
    ResponseData<PageInfo<TBasicMerchantVo>> pageList(@RequestBody TBasicMerchantPageReq req);

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(value = "商户列表")
    ResponseData<List<TBasicMerchantVo>> list(@RequestBody TBasicMerchantVo req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "添加商户")
    ResponseData<Boolean> save(@RequestBody TBasicMerchantVo req);

    @RequestMapping(value = "/modify", method = RequestMethod.POST)
    @ApiOperation(value = "编辑商户")
    ResponseData<Boolean> modify(@RequestBody TBasicMerchantVo req);

    @RequestMapping(value = "/search/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "商户条件搜索分页查询",notes = "适用于用于商户弹窗选择")
    ResponseData<PageInfo<TBasicMerchantVo>> searchPageList(@RequestBody TBasicMerchantSearchPageReq req);

    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    @ApiOperation(value = "详情")
    ResponseData<TBasicMerchantVo> detail(@RequestBody TBasicMerchantVo req);


    @RequestMapping(value = "/listByOrgCode", method = RequestMethod.POST)
    @ApiOperation(value = "商户列表")
    ResponseData<List<TBasicMerchantVo>> listByOrgCode(@RequestBody TBasicMerchantVo req);







}
