package com.bizvane.basic.feign.feign;

import com.bizvane.basic.feign.model.req.approve.*;
import com.bizvane.basic.feign.model.rsp.approve.QueryApproveTaskListResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBasicApproveTask")
@Api(value = "审批任务RPC")
public interface BasicApproveTaskRpcFeign {


    @PostMapping("/pageList")
    @ApiOperation(value = "分页查询列表")
    ResponseData<PageInfo<QueryApproveTaskListResponseVO>> pageList(@RequestBody @Validated QueryApproveTaskListRequestVO request);


    @GetMapping("/queryExpireList")
    @ApiOperation(value = "查询过期的任务列表")
    ResponseData<List<QueryApproveTaskListResponseVO>> queryExpireList();


    @PostMapping("/updateApproveStatus")
    @ApiOperation(value = "更新审核任务状态")
    ResponseData<Boolean> updateApproveStatus(@RequestBody @Validated AuditApproveTaskRequestVO request);


    @PostMapping("/audit")
    @ApiOperation(value = "审核")
    ResponseData<Boolean> audit(@RequestBody @Validated AuditApproveTaskRequestVO request);


    @PostMapping("/detail")
    @ApiOperation(value = "详情")
    ResponseData<QueryApproveTaskListResponseVO> detail(@RequestBody @Validated QueryApproveTaskRequestVO request);


    @PostMapping("/processing/count")
    @ApiOperation(value = "待我处理审批任务数量、消息统计")
    ResponseData<Long> processingCount(@RequestBody QueryUserRecentMessageRequestVO request);


    @PostMapping("/add")
    @ApiOperation(value = "添加审批任务")
    ResponseData<Boolean> add(@RequestBody @Validated AddApproveTaskReqVO request);


    @PostMapping("/verify")
    @ApiOperation(value = "校验当前业务是否需要生成审批任务")
    ResponseData<Boolean> verify(@RequestBody @Validated VerifyApproveTaskReqVO request);
}
