package com.bizvane.basic.feign.model.vo;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
@ToString
public class PageListVo<T> extends PageBaseVo {


    private List<T> list = new ArrayList<>();

    public PageListVo() {
    }


    public PageListVo(List<T> list, int total, int pages, int pageNum, int pageSize) {
        this.list = list;
        super.setPageNum(pageNum);
        super.setPageSize(pageSize);
        super.setPages(pages);
        super.setTotal(total);
    }

    public PageListVo(List<T> list, int total, int pageNum, int pageSize) {
        this.list = list;
        super.setPageNum(pageNum);
        super.setPageSize(pageSize);
        super.setPages(pageSize > 0 ? (total % pageSize == 0 ? total / pageSize : total / pageSize + 1) : 0);
        super.setTotal(total);
    }

    public void setPages() {
        int total = this.getTotal();
        int pageSize = this.getPageSize();
        super.setPages(pageSize > 0 ? (total % pageSize == 0 ? total / pageSize : total / pageSize + 1) : 0);
    }
}
