/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.base.store.config;

import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.ErrorInfo;
import com.bizvane.base.common.bean.ResultBean;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionResolver.class);

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public String handlerValidationException(MissingServletRequestParameterException e) {
        log.error("\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        ResultBean result = new ResultBean();
        result.setErrorInfo(new ErrorInfo("1011", "\u53c2\u6570\u4f20\u9012\u95ee\u9898 (\u7ed9\u4f60\u70b9\u63d0\u793a\uff1a" + e.getMessage() + ")"));
        result.setSuccess(Boolean.valueOf(false));
        return JSON.toJSONString((Object)result);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public String handlerValidationException(HttpRequestMethodNotSupportedException e) {
        log.error("\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        ResultBean result = new ResultBean();
        result.setErrorInfo(new ErrorInfo("1012", "\u8bf7\u6c42\u65b9\u5f0f\u9519\u8bef"));
        result.setSuccess(Boolean.valueOf(false));
        return JSON.toJSONString((Object)result);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public String handlerValidationException(Exception e) {
        log.error("\u5168\u5c40\u62e6\u622a\u5f02\u5e38\u4fe1\u606f:{},{}", (Object)e.getMessage(), (Object)e);
        ResultBean result = new ResultBean();
        result.setErrorInfo(new ErrorInfo("1013", "\u5185\u90e8\u670d\u52a1\u5f02\u5e38"));
        result.setSuccess(Boolean.valueOf(false));
        return JSON.toJSONString((Object)result);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public String handlerValidationException(MethodArgumentNotValidException e) {
        log.error("\u5165\u53c2\u6821\u9a8c\u672a\u901a\u8fc7:{},{}", (Object)e.getMessage(), (Object)e);
        ResultBean result = new ResultBean();
        StringBuffer sb = new StringBuffer("\u5165\u53c2\u6821\u9a8c\u672a\u901a\u8fc7\u539f\u56e0:");
        BindingResult bindingResult = e.getBindingResult();
        for (FieldError f : bindingResult.getFieldErrors()) {
            sb.append(f.getField()).append(f.getDefaultMessage()).append(";");
        }
        result.setErrorInfo(new ErrorInfo("1014", sb.toString()));
        return JSON.toJSONString((Object)result);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    public String handlerValidationException(ConstraintViolationException e) {
        log.error("\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        ResultBean result = new ResultBean();
        result.setErrorInfo(new ErrorInfo("1015", e.getMessage()));
        return JSON.toJSONString((Object)result);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public String handlerValidationException(IllegalArgumentException e) {
        log.error("\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
        ResultBean result = new ResultBean();
        result.setErrorInfo(new ErrorInfo("1015", e.getMessage()));
        return JSON.toJSONString((Object)result);
    }
}

